% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_set_user_password}
\alias{cognitoidentityprovider_admin_set_user_password}
\title{Sets the specified user's password in a user pool}
\usage{
cognitoidentityprovider_admin_set_user_password(
  UserPoolId,
  Username,
  Password,
  Permanent = NULL
)
}
\arguments{
\item{UserPoolId}{[required] The ID of the user pool where you want to set the user's password.}

\item{Username}{[required] The username of the user that you want to query or modify. The value of
this parameter is typically your user's username, but it can be any of
their alias attributes. If \code{username} isn't an alias attribute in your
user pool, this value must be the \code{sub} of a local user or the username
of a user from a third-party IdP.}

\item{Password}{[required] The new temporary or permanent password that you want to set for the
user. You can't remove the password for a user who already has a
password so that they can only sign in with passwordless methods. In
this scenario, you must create a new user without a password.}

\item{Permanent}{Set to \code{true} to set a password that the user can immediately sign in
with. Set to \code{false} to set a temporary password that the user must
change on their next sign-in.}
}
\description{
Sets the specified user's password in a user pool. This operation administratively sets a temporary or permanent password for a user. With this operation, you can bypass self-service password changes and permit immediate sign-in with the password that you set. To do this, set \code{Permanent} to \code{true}.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_set_user_password/} for full documentation.
}
\keyword{internal}
