% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_list_devices}
\alias{cognitoidentityprovider_admin_list_devices}
\title{Lists a user's registered devices}
\usage{
cognitoidentityprovider_admin_list_devices(
  UserPoolId,
  Username,
  Limit = NULL,
  PaginationToken = NULL
)
}
\arguments{
\item{UserPoolId}{[required] The ID of the user pool where the device owner is a user.}

\item{Username}{[required] The username of the user that you want to query or modify. The value of
this parameter is typically your user's username, but it can be any of
their alias attributes. If \code{username} isn't an alias attribute in your
user pool, this value must be the \code{sub} of a local user or the username
of a user from a third-party IdP.}

\item{Limit}{The maximum number of devices that you want Amazon Cognito to return in
the response.}

\item{PaginationToken}{This API operation returns a limited number of results. The pagination
token is an identifier that you can present in an additional API request
with the same parameters. When you include the pagination token, Amazon
Cognito returns the next set of items after the current list. Subsequent
requests return a new pagination token. By use of this token, you can
paginate through the full list of items.}
}
\description{
Lists a user's registered devices. Remembered devices are used in authentication services where you offer a "Remember me" option for users who you want to permit to sign in without MFA from a trusted device. Users can bypass MFA while your application performs device SRP authentication on the back end. For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html}{Working with devices}.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_list_devices/} for full documentation.
}
\keyword{internal}
