# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS SSO OIDC
#'
#' @description
#' IAM Identity Center OpenID Connect (OIDC) is a web service that enables
#' a client (such as CLI or a native application) to register with IAM
#' Identity Center. The service also enables the client to fetch the user’s
#' access token upon successful authentication and authorization with IAM
#' Identity Center.
#' 
#' IAM Identity Center uses the `sso` and `identitystore` API namespaces.
#' 
#' **Considerations for Using This Guide**
#' 
#' Before you begin using this guide, we recommend that you first review
#' the following important information about how the IAM Identity Center
#' OIDC service works.
#' 
#' -   The IAM Identity Center OIDC service currently implements only the
#'     portions of the OAuth 2.0 Device Authorization Grant standard
#'     ([https://tools.ietf.org/html/rfc8628](https://datatracker.ietf.org/doc/html/rfc8628))
#'     that are necessary to enable single sign-on authentication with the
#'     CLI.
#' 
#' -   With older versions of the CLI, the service only emits OIDC access
#'     tokens, so to obtain a new token, users must explicitly
#'     re-authenticate. To access the OIDC flow that supports token refresh
#'     and doesn’t require re-authentication, update to the latest CLI
#'     version (1.27.10 for CLI V1 and 2.9.0 for CLI V2) with support for
#'     OIDC token refresh and configurable IAM Identity Center session
#'     durations. For more information, see [Configure Amazon Web Services
#'     access portal session
#'     duration](https://docs.aws.amazon.com/singlesignon/latest/userguide/configure-user-session.html)
#'     .
#' 
#' -   The access tokens provided by this service grant access to all
#'     Amazon Web Services account entitlements assigned to an IAM Identity
#'     Center user, not just a particular application.
#' 
#' -   The documentation in this guide does not describe the mechanism to
#'     convert the access token into Amazon Web Services Auth (“sigv4”)
#'     credentials for use with IAM-protected Amazon Web Services service
#'     endpoints. For more information, see
#'     [GetRoleCredentials](https://docs.aws.amazon.com/singlesignon/latest/PortalAPIReference/API_GetRoleCredentials.html)
#'     in the *IAM Identity Center Portal API Reference Guide*.
#' 
#' For general information about IAM Identity Center, see [What is IAM
#' Identity
#' Center?](https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html)
#' in the *IAM Identity Center User Guide*.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- ssooidc(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- ssooidc()
#' svc$create_token(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=ssooidc_create_token]{create_token} \tab Creates and returns access and refresh tokens for clients that are authenticated using client secrets\cr
#'  \link[=ssooidc_create_token_with_iam]{create_token_with_iam} \tab Creates and returns access and refresh tokens for clients and applications that are authenticated using IAM entities\cr
#'  \link[=ssooidc_register_client]{register_client} \tab Registers a client with IAM Identity Center\cr
#'  \link[=ssooidc_start_device_authorization]{start_device_authorization} \tab Initiates device authorization by requesting a pair of verification codes from the authorization service
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname ssooidc
#' @export
ssooidc <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .ssooidc$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.ssooidc <- list()

.ssooidc$operations <- list()

.ssooidc$metadata <- list(
  service_name = "ssooidc",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "oidc.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "oidc.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "oidc.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "oidc.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "oidc.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "oidc.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "oidc.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "SSO OIDC",
  api_version = "2019-06-10",
  signing_name = "sso-oauth",
  json_version = "1.1",
  target_prefix = ""
)

.ssooidc$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.ssooidc$metadata, handlers, config, op)
}
