% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentity_operations.R
\name{cognitoidentity_update_identity_pool}
\alias{cognitoidentity_update_identity_pool}
\title{Updates an identity pool}
\usage{
cognitoidentity_update_identity_pool(
  IdentityPoolId,
  IdentityPoolName,
  AllowUnauthenticatedIdentities,
  AllowClassicFlow = NULL,
  SupportedLoginProviders = NULL,
  DeveloperProviderName = NULL,
  OpenIdConnectProviderARNs = NULL,
  CognitoIdentityProviders = NULL,
  SamlProviderARNs = NULL,
  IdentityPoolTags = NULL
)
}
\arguments{
\item{IdentityPoolId}{[required] An identity pool ID in the format REGION:GUID.}

\item{IdentityPoolName}{[required] A string that you provide.}

\item{AllowUnauthenticatedIdentities}{[required] TRUE if the identity pool supports unauthenticated logins.}

\item{AllowClassicFlow}{Enables or disables the Basic (Classic) authentication flow. For more
information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flow.html}{Identity Pools (Federated Identities) Authentication Flow}
in the \emph{Amazon Cognito Developer Guide}.}

\item{SupportedLoginProviders}{Optional key:value pairs mapping provider names to provider app IDs.}

\item{DeveloperProviderName}{The "domain" by which Cognito will refer to your users.}

\item{OpenIdConnectProviderARNs}{The ARNs of the OpenID Connect providers.}

\item{CognitoIdentityProviders}{A list representing an Amazon Cognito user pool and its client ID.}

\item{SamlProviderARNs}{An array of Amazon Resource Names (ARNs) of the SAML provider for your
identity pool.}

\item{IdentityPoolTags}{The tags that are assigned to the identity pool. A tag is a label that
you can apply to identity pools to categorize and manage them in
different ways, such as by purpose, owner, environment, or other
criteria.}
}
\description{
Updates an identity pool.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentity_update_identity_pool/} for full documentation.
}
\keyword{internal}
