# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon CloudDirectory
#'
#' @description
#' Amazon Cloud Directory
#' 
#' Amazon Cloud Directory is a component of the AWS Directory Service that
#' simplifies the development and management of cloud-scale web, mobile,
#' and IoT applications. This guide describes the Cloud Directory
#' operations that you can call programmatically and includes detailed
#' information on data types and errors. For information about Cloud
#' Directory features, see [AWS Directory
#' Service](https://aws.amazon.com/directoryservice/) and the [Amazon Cloud
#' Directory Developer
#' Guide](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/what_is_cloud_directory.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- clouddirectory(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- clouddirectory()
#' svc$add_facet_to_object(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=clouddirectory_add_facet_to_object]{add_facet_to_object} \tab Adds a new Facet to an object\cr
#'  \link[=clouddirectory_apply_schema]{apply_schema} \tab Copies the input published schema, at the specified version, into the Directory with the same name and version as that of the published schema\cr
#'  \link[=clouddirectory_attach_object]{attach_object} \tab Attaches an existing object to another object\cr
#'  \link[=clouddirectory_attach_policy]{attach_policy} \tab Attaches a policy object to a regular object\cr
#'  \link[=clouddirectory_attach_to_index]{attach_to_index} \tab Attaches the specified object to the specified index\cr
#'  \link[=clouddirectory_attach_typed_link]{attach_typed_link} \tab Attaches a typed link to a specified source and target object\cr
#'  \link[=clouddirectory_batch_read]{batch_read} \tab Performs all the read operations in a batch\cr
#'  \link[=clouddirectory_batch_write]{batch_write} \tab Performs all the write operations in a batch\cr
#'  \link[=clouddirectory_create_directory]{create_directory} \tab Creates a Directory by copying the published schema into the directory\cr
#'  \link[=clouddirectory_create_facet]{create_facet} \tab Creates a new Facet in a schema\cr
#'  \link[=clouddirectory_create_index]{create_index} \tab Creates an index object\cr
#'  \link[=clouddirectory_create_object]{create_object} \tab Creates an object in a Directory\cr
#'  \link[=clouddirectory_create_schema]{create_schema} \tab Creates a new schema in a development state\cr
#'  \link[=clouddirectory_create_typed_link_facet]{create_typed_link_facet} \tab Creates a TypedLinkFacet\cr
#'  \link[=clouddirectory_delete_directory]{delete_directory} \tab Deletes a directory\cr
#'  \link[=clouddirectory_delete_facet]{delete_facet} \tab Deletes a given Facet\cr
#'  \link[=clouddirectory_delete_object]{delete_object} \tab Deletes an object and its associated attributes\cr
#'  \link[=clouddirectory_delete_schema]{delete_schema} \tab Deletes a given schema\cr
#'  \link[=clouddirectory_delete_typed_link_facet]{delete_typed_link_facet} \tab Deletes a TypedLinkFacet\cr
#'  \link[=clouddirectory_detach_from_index]{detach_from_index} \tab Detaches the specified object from the specified index\cr
#'  \link[=clouddirectory_detach_object]{detach_object} \tab Detaches a given object from the parent object\cr
#'  \link[=clouddirectory_detach_policy]{detach_policy} \tab Detaches a policy from an object\cr
#'  \link[=clouddirectory_detach_typed_link]{detach_typed_link} \tab Detaches a typed link from a specified source and target object\cr
#'  \link[=clouddirectory_disable_directory]{disable_directory} \tab Disables the specified directory\cr
#'  \link[=clouddirectory_enable_directory]{enable_directory} \tab Enables the specified directory\cr
#'  \link[=clouddirectory_get_applied_schema_version]{get_applied_schema_version} \tab Returns current applied schema version ARN, including the minor version in use\cr
#'  \link[=clouddirectory_get_directory]{get_directory} \tab Retrieves metadata about a directory\cr
#'  \link[=clouddirectory_get_facet]{get_facet} \tab Gets details of the Facet, such as facet name, attributes, Rules, or ObjectType\cr
#'  \link[=clouddirectory_get_link_attributes]{get_link_attributes} \tab Retrieves attributes that are associated with a typed link\cr
#'  \link[=clouddirectory_get_object_attributes]{get_object_attributes} \tab Retrieves attributes within a facet that are associated with an object\cr
#'  \link[=clouddirectory_get_object_information]{get_object_information} \tab Retrieves metadata about an object\cr
#'  \link[=clouddirectory_get_schema_as_json]{get_schema_as_json} \tab Retrieves a JSON representation of the schema\cr
#'  \link[=clouddirectory_get_typed_link_facet_information]{get_typed_link_facet_information} \tab Returns the identity attribute order for a specific TypedLinkFacet\cr
#'  \link[=clouddirectory_list_applied_schema_arns]{list_applied_schema_arns} \tab Lists schema major versions applied to a directory\cr
#'  \link[=clouddirectory_list_attached_indices]{list_attached_indices} \tab Lists indices attached to the specified object\cr
#'  \link[=clouddirectory_list_development_schema_arns]{list_development_schema_arns} \tab Retrieves each Amazon Resource Name (ARN) of schemas in the development state\cr
#'  \link[=clouddirectory_list_directories]{list_directories} \tab Lists directories created within an account\cr
#'  \link[=clouddirectory_list_facet_attributes]{list_facet_attributes} \tab Retrieves attributes attached to the facet\cr
#'  \link[=clouddirectory_list_facet_names]{list_facet_names} \tab Retrieves the names of facets that exist in a schema\cr
#'  \link[=clouddirectory_list_incoming_typed_links]{list_incoming_typed_links} \tab Returns a paginated list of all the incoming TypedLinkSpecifier information for an object\cr
#'  \link[=clouddirectory_list_index]{list_index} \tab Lists objects attached to the specified index\cr
#'  \link[=clouddirectory_list_managed_schema_arns]{list_managed_schema_arns} \tab Lists the major version families of each managed schema\cr
#'  \link[=clouddirectory_list_object_attributes]{list_object_attributes} \tab Lists all attributes that are associated with an object\cr
#'  \link[=clouddirectory_list_object_children]{list_object_children} \tab Returns a paginated list of child objects that are associated with a given object\cr
#'  \link[=clouddirectory_list_object_parent_paths]{list_object_parent_paths} \tab Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects\cr
#'  \link[=clouddirectory_list_object_parents]{list_object_parents} \tab Lists parent objects that are associated with a given object in pagination fashion\cr
#'  \link[=clouddirectory_list_object_policies]{list_object_policies} \tab Returns policies attached to an object in pagination fashion\cr
#'  \link[=clouddirectory_list_outgoing_typed_links]{list_outgoing_typed_links} \tab Returns a paginated list of all the outgoing TypedLinkSpecifier information for an object\cr
#'  \link[=clouddirectory_list_policy_attachments]{list_policy_attachments} \tab Returns all of the ObjectIdentifiers to which a given policy is attached\cr
#'  \link[=clouddirectory_list_published_schema_arns]{list_published_schema_arns} \tab Lists the major version families of each published schema\cr
#'  \link[=clouddirectory_list_tags_for_resource]{list_tags_for_resource} \tab Returns tags for a resource\cr
#'  \link[=clouddirectory_list_typed_link_facet_attributes]{list_typed_link_facet_attributes} \tab Returns a paginated list of all attribute definitions for a particular TypedLinkFacet\cr
#'  \link[=clouddirectory_list_typed_link_facet_names]{list_typed_link_facet_names} \tab Returns a paginated list of TypedLink facet names for a particular schema\cr
#'  \link[=clouddirectory_lookup_policy]{lookup_policy} \tab Lists all policies from the root of the Directory to the object specified\cr
#'  \link[=clouddirectory_publish_schema]{publish_schema} \tab Publishes a development schema with a major version and a recommended minor version\cr
#'  \link[=clouddirectory_put_schema_from_json]{put_schema_from_json} \tab Allows a schema to be updated using JSON upload\cr
#'  \link[=clouddirectory_remove_facet_from_object]{remove_facet_from_object} \tab Removes the specified facet from the specified object\cr
#'  \link[=clouddirectory_tag_resource]{tag_resource} \tab An API operation for adding tags to a resource\cr
#'  \link[=clouddirectory_untag_resource]{untag_resource} \tab An API operation for removing tags from a resource\cr
#'  \link[=clouddirectory_update_facet]{update_facet} \tab Does the following:\cr
#'  \link[=clouddirectory_update_link_attributes]{update_link_attributes} \tab Updates a given typed link’s attributes\cr
#'  \link[=clouddirectory_update_object_attributes]{update_object_attributes} \tab Updates a given object's attributes\cr
#'  \link[=clouddirectory_update_schema]{update_schema} \tab Updates the schema name with a new name\cr
#'  \link[=clouddirectory_update_typed_link_facet]{update_typed_link_facet} \tab Updates a TypedLinkFacet\cr
#'  \link[=clouddirectory_upgrade_applied_schema]{upgrade_applied_schema} \tab Upgrades a single directory in-place using the PublishedSchemaArn with schema updates found in MinorVersion\cr
#'  \link[=clouddirectory_upgrade_published_schema]{upgrade_published_schema} \tab Upgrades a published schema under a new minor version revision using the current contents of DevelopmentSchemaArn
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname clouddirectory
#' @export
clouddirectory <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .clouddirectory$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.clouddirectory <- list()

.clouddirectory$operations <- list()

.clouddirectory$metadata <- list(
  service_name = "clouddirectory",
  endpoints = list("*" = list(endpoint = "clouddirectory.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "clouddirectory.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "clouddirectory.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "clouddirectory.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "clouddirectory.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "clouddirectory.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "CloudDirectory",
  api_version = "2017-01-11",
  signing_name = "clouddirectory",
  json_version = "",
  target_prefix = ""
)

.clouddirectory$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.clouddirectory$metadata, handlers, config)
}
