% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verifiedpermissions_operations.R
\name{verifiedpermissions_create_identity_source}
\alias{verifiedpermissions_create_identity_source}
\title{Creates a reference to an Amazon Cognito user pool as an external
identity provider (IdP)}
\usage{
verifiedpermissions_create_identity_source(
  clientToken = NULL,
  policyStoreId,
  configuration,
  principalEntityType = NULL
)
}
\arguments{
\item{clientToken}{Specifies a unique, case-sensitive ID that you provide to ensure the
idempotency of the request. This lets you safely retry the request
without accidentally performing the same operation a second time.
Passing the same value to a later call to an operation requires that you
also pass the same value for all other parameters. We recommend that you
use a \href{https://en.wikipedia.org/wiki/Universally_unique_identifier}{UUID type of value.}.

If you don't provide this value, then Amazon Web Services generates a
random one for you.

If you retry the operation with the same \code{ClientToken}, but with
different parameters, the retry fails with an
\code{IdempotentParameterMismatch} error.}

\item{policyStoreId}{[required] Specifies the ID of the policy store in which you want to store this
identity source. Only policies and requests made using this policy store
can reference identities from the identity provider configured in the
new identity source.}

\item{configuration}{[required] Specifies the details required to communicate with the identity provider
(IdP) associated with this identity source.

At this time, the only valid member of this structure is a Amazon
Cognito user pool configuration.

You must specify a \code{UserPoolArn}, and optionally, a \code{ClientId}.}

\item{principalEntityType}{Specifies the namespace and data type of the principals generated for
identities authenticated by the new identity source.}
}
\description{
Creates a reference to an Amazon Cognito user pool as an external identity provider (IdP).

See \url{https://www.paws-r-sdk.com/docs/verifiedpermissions_create_identity_source/} for full documentation.
}
\keyword{internal}
