# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include macie_service.R
NULL

#' (Discontinued) Associates a specified Amazon Web Services account with
#' Amazon Macie Classic as a member account
#'
#' @description
#' (Discontinued) Associates a specified Amazon Web Services account with Amazon Macie Classic as a member account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie_associate_member_account/](https://www.paws-r-sdk.com/docs/macie_associate_member_account/) for full documentation.
#'
#' @param memberAccountId &#91;required&#93; (Discontinued) The ID of the Amazon Web Services account that you want
#' to associate with Amazon Macie Classic as a member account.
#'
#' @keywords internal
#'
#' @rdname macie_associate_member_account
macie_associate_member_account <- function(memberAccountId) {
  op <- new_operation(
    name = "AssociateMemberAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .macie$associate_member_account_input(memberAccountId = memberAccountId)
  output <- .macie$associate_member_account_output()
  config <- get_config()
  svc <- .macie$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie$operations$associate_member_account <- macie_associate_member_account

#' (Discontinued) Associates specified S3 resources with Amazon Macie
#' Classic for monitoring and data classification
#'
#' @description
#' (Discontinued) Associates specified S3 resources with Amazon Macie Classic for monitoring and data classification. If `memberAccountId` isn't specified, the action associates specified S3 resources with Macie Classic for the current Macie Classic administrator account. If `memberAccountId` is specified, the action associates specified S3 resources with Macie Classic for the specified member account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie_associate_s3_resources/](https://www.paws-r-sdk.com/docs/macie_associate_s3_resources/) for full documentation.
#'
#' @param memberAccountId (Discontinued) The ID of the Amazon Macie Classic member account whose
#' resources you want to associate with Macie Classic.
#' @param s3Resources &#91;required&#93; (Discontinued) The S3 resources that you want to associate with Amazon
#' Macie Classic for monitoring and data classification.
#'
#' @keywords internal
#'
#' @rdname macie_associate_s3_resources
macie_associate_s3_resources <- function(memberAccountId = NULL, s3Resources) {
  op <- new_operation(
    name = "AssociateS3Resources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .macie$associate_s3_resources_input(memberAccountId = memberAccountId, s3Resources = s3Resources)
  output <- .macie$associate_s3_resources_output()
  config <- get_config()
  svc <- .macie$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie$operations$associate_s3_resources <- macie_associate_s3_resources

#' (Discontinued) Removes the specified member account from Amazon Macie
#' Classic
#'
#' @description
#' (Discontinued) Removes the specified member account from Amazon Macie Classic.
#'
#' See [https://www.paws-r-sdk.com/docs/macie_disassociate_member_account/](https://www.paws-r-sdk.com/docs/macie_disassociate_member_account/) for full documentation.
#'
#' @param memberAccountId &#91;required&#93; (Discontinued) The ID of the member account that you want to remove from
#' Amazon Macie Classic.
#'
#' @keywords internal
#'
#' @rdname macie_disassociate_member_account
macie_disassociate_member_account <- function(memberAccountId) {
  op <- new_operation(
    name = "DisassociateMemberAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .macie$disassociate_member_account_input(memberAccountId = memberAccountId)
  output <- .macie$disassociate_member_account_output()
  config <- get_config()
  svc <- .macie$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie$operations$disassociate_member_account <- macie_disassociate_member_account

#' (Discontinued) Removes specified S3 resources from being monitored by
#' Amazon Macie Classic
#'
#' @description
#' (Discontinued) Removes specified S3 resources from being monitored by Amazon Macie Classic. If `memberAccountId` isn't specified, the action removes specified S3 resources from Macie Classic for the current Macie Classic administrator account. If `memberAccountId` is specified, the action removes specified S3 resources from Macie Classic for the specified member account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie_disassociate_s3_resources/](https://www.paws-r-sdk.com/docs/macie_disassociate_s3_resources/) for full documentation.
#'
#' @param memberAccountId (Discontinued) The ID of the Amazon Macie Classic member account whose
#' resources you want to remove from being monitored by Macie Classic.
#' @param associatedS3Resources &#91;required&#93; (Discontinued) The S3 resources (buckets or prefixes) that you want to
#' remove from being monitored and classified by Amazon Macie Classic.
#'
#' @keywords internal
#'
#' @rdname macie_disassociate_s3_resources
macie_disassociate_s3_resources <- function(memberAccountId = NULL, associatedS3Resources) {
  op <- new_operation(
    name = "DisassociateS3Resources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .macie$disassociate_s3_resources_input(memberAccountId = memberAccountId, associatedS3Resources = associatedS3Resources)
  output <- .macie$disassociate_s3_resources_output()
  config <- get_config()
  svc <- .macie$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie$operations$disassociate_s3_resources <- macie_disassociate_s3_resources

#' (Discontinued) Lists all Amazon Macie Classic member accounts for the
#' current Macie Classic administrator account
#'
#' @description
#' (Discontinued) Lists all Amazon Macie Classic member accounts for the current Macie Classic administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie_list_member_accounts/](https://www.paws-r-sdk.com/docs/macie_list_member_accounts/) for full documentation.
#'
#' @param nextToken (Discontinued) Use this parameter when paginating results. Set the value
#' of this parameter to null on your first call to the
#' [`list_member_accounts`][macie_list_member_accounts] action. Subsequent
#' calls to the action fill `nextToken` in the request with the value of
#' `nextToken` from the previous response to continue listing data.
#' @param maxResults (Discontinued) Use this parameter to indicate the maximum number of
#' items that you want in the response. The default value is 250.
#'
#' @keywords internal
#'
#' @rdname macie_list_member_accounts
macie_list_member_accounts <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListMemberAccounts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .macie$list_member_accounts_input(nextToken = nextToken, maxResults = maxResults)
  output <- .macie$list_member_accounts_output()
  config <- get_config()
  svc <- .macie$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie$operations$list_member_accounts <- macie_list_member_accounts

#' (Discontinued) Lists all the S3 resources associated with Amazon Macie
#' Classic
#'
#' @description
#' (Discontinued) Lists all the S3 resources associated with Amazon Macie Classic. If `memberAccountId` isn't specified, the action lists the S3 resources associated with Macie Classic for the current Macie Classic administrator account. If `memberAccountId` is specified, the action lists the S3 resources associated with Macie Classic for the specified member account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie_list_s3_resources/](https://www.paws-r-sdk.com/docs/macie_list_s3_resources/) for full documentation.
#'
#' @param memberAccountId (Discontinued) The Amazon Macie Classic member account ID whose
#' associated S3 resources you want to list.
#' @param nextToken (Discontinued) Use this parameter when paginating results. Set its value
#' to null on your first call to the
#' [`list_s3_resources`][macie_list_s3_resources] action. Subsequent calls
#' to the action fill `nextToken` in the request with the value of
#' `nextToken` from the previous response to continue listing data.
#' @param maxResults (Discontinued) Use this parameter to indicate the maximum number of
#' items that you want in the response. The default value is 250.
#'
#' @keywords internal
#'
#' @rdname macie_list_s3_resources
macie_list_s3_resources <- function(memberAccountId = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListS3Resources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .macie$list_s3_resources_input(memberAccountId = memberAccountId, nextToken = nextToken, maxResults = maxResults)
  output <- .macie$list_s3_resources_output()
  config <- get_config()
  svc <- .macie$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie$operations$list_s3_resources <- macie_list_s3_resources

#' (Discontinued) Updates the classification types for the specified S3
#' resources
#'
#' @description
#' (Discontinued) Updates the classification types for the specified S3 resources. If `memberAccountId` isn't specified, the action updates the classification types of the S3 resources associated with Amazon Macie Classic for the current Macie Classic administrator account. If `memberAccountId` is specified, the action updates the classification types of the S3 resources associated with Macie Classic for the specified member account.
#'
#' See [https://www.paws-r-sdk.com/docs/macie_update_s3_resources/](https://www.paws-r-sdk.com/docs/macie_update_s3_resources/) for full documentation.
#'
#' @param memberAccountId (Discontinued) The Amazon Web Services account ID of the Amazon Macie
#' Classic member account whose S3 resources' classification types you want
#' to update.
#' @param s3ResourcesUpdate &#91;required&#93; (Discontinued) The S3 resources whose classification types you want to
#' update.
#'
#' @keywords internal
#'
#' @rdname macie_update_s3_resources
macie_update_s3_resources <- function(memberAccountId = NULL, s3ResourcesUpdate) {
  op <- new_operation(
    name = "UpdateS3Resources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .macie$update_s3_resources_input(memberAccountId = memberAccountId, s3ResourcesUpdate = s3ResourcesUpdate)
  output <- .macie$update_s3_resources_output()
  config <- get_config()
  svc <- .macie$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.macie$operations$update_s3_resources <- macie_update_s3_resources
