% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_create_web_acl_migration_stack}
\alias{wafregional_create_web_acl_migration_stack}
\title{Creates an AWS CloudFormation WAFV2 template for the specified web ACL
in the specified Amazon S3 bucket}
\usage{
wafregional_create_web_acl_migration_stack(
  WebACLId,
  S3BucketName,
  IgnoreUnsupportedType
)
}
\arguments{
\item{WebACLId}{[required] The UUID of the WAF Classic web ACL that you want to migrate to WAF v2.}

\item{S3BucketName}{[required] The name of the Amazon S3 bucket to store the CloudFormation template
in. The S3 bucket must be configured as follows for the migration:
\itemize{
\item The bucket name must start with \verb{aws-waf-migration-}. For example,
\code{aws-waf-migration-my-web-acl}.
\item The bucket must be in the Region where you are deploying the
template. For example, for a web ACL in us-west-2, you must use an
Amazon S3 bucket in us-west-2 and you must deploy the template stack
to us-west-2.
\item The bucket policies must permit the migration process to write data.
For listings of the bucket policies, see the Examples section.
}}

\item{IgnoreUnsupportedType}{[required] Indicates whether to exclude entities that can't be migrated or to stop
the migration. Set this to true to ignore unsupported entities in the
web ACL during the migration. Otherwise, if AWS WAF encounters
unsupported entities, it stops the process and throws an exception.}
}
\description{
Creates an AWS CloudFormation WAFV2 template for the specified web ACL in the specified Amazon S3 bucket. Then, in CloudFormation, you create a stack from the template, to create the web ACL and its resources in AWS WAFV2. Use this to migrate your AWS WAF Classic web ACL to the latest version of AWS WAF.

See \url{https://paws-r.github.io/docs/wafregional/create_web_acl_migration_stack.html} for full documentation.
}
\keyword{internal}
