% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_untag_resource}
\alias{secretsmanager_untag_resource}
\title{Removes specific tags from a secret}
\usage{
secretsmanager_untag_resource(SecretId, TagKeys)
}
\arguments{
\item{SecretId}{[required] The ARN or name of the secret.

For an ARN, we recommend that you specify a complete ARN rather than a
partial ARN. See \href{https://docs.aws.amazon.com/secretsmanager/latest/userguide/troubleshoot.html#ARN_secretnamehyphen}{Finding a secret from a partial ARN}.}

\item{TagKeys}{[required] A list of tag key names to remove from the secret. You don't specify the
value. Both the key and its associated value are removed.

This parameter requires a JSON text string argument.

For storing multiple values, we recommend that you use a JSON text
string argument and specify key/value pairs. For more information, see
\href{https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters.html}{Specifying parameter values for the Amazon Web Services CLI}
in the Amazon Web Services CLI User Guide.}
}
\description{
Removes specific tags from a secret.

See \url{https://paws-r.github.io/docs/secretsmanager/untag_resource.html} for full documentation.
}
\keyword{internal}
