% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_disconnect_custom_key_store}
\alias{kms_disconnect_custom_key_store}
\title{Disconnects the custom key store from its associated CloudHSM cluster}
\usage{
kms_disconnect_custom_key_store(CustomKeyStoreId)
}
\arguments{
\item{CustomKeyStoreId}{[required] Enter the ID of the custom key store you want to disconnect. To find the
ID of a custom key store, use the
\code{\link[=kms_describe_custom_key_stores]{describe_custom_key_stores}}
operation.}
}
\description{
Disconnects the \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key store} from its associated CloudHSM cluster. While a custom key store is disconnected, you can manage the custom key store and its KMS keys, but you cannot create or use KMS keys in the custom key store. You can reconnect the custom key store at any time.

See \url{https://paws-r.github.io/docs/kms/disconnect_custom_key_store.html} for full documentation.
}
\keyword{internal}
