% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_account_password_policy}
\alias{iam_update_account_password_policy}
\title{Updates the password policy settings for the Amazon Web Services account}
\usage{
iam_update_account_password_policy(
  MinimumPasswordLength = NULL,
  RequireSymbols = NULL,
  RequireNumbers = NULL,
  RequireUppercaseCharacters = NULL,
  RequireLowercaseCharacters = NULL,
  AllowUsersToChangePassword = NULL,
  MaxPasswordAge = NULL,
  PasswordReusePrevention = NULL,
  HardExpiry = NULL
)
}
\arguments{
\item{MinimumPasswordLength}{The minimum number of characters allowed in an IAM user password.

If you do not specify a value for this parameter, then the operation
uses the default value of \code{6}.}

\item{RequireSymbols}{Specifies whether IAM user passwords must contain at least one of the
following non-alphanumeric characters:

! @ # $ \% ^ & * ( ) _ + - = [ ] \{ \} | '

If you do not specify a value for this parameter, then the operation
uses the default value of \code{false}. The result is that passwords do not
require at least one symbol character.}

\item{RequireNumbers}{Specifies whether IAM user passwords must contain at least one numeric
character (0 to 9).

If you do not specify a value for this parameter, then the operation
uses the default value of \code{false}. The result is that passwords do not
require at least one numeric character.}

\item{RequireUppercaseCharacters}{Specifies whether IAM user passwords must contain at least one uppercase
character from the ISO basic Latin alphabet (A to Z).

If you do not specify a value for this parameter, then the operation
uses the default value of \code{false}. The result is that passwords do not
require at least one uppercase character.}

\item{RequireLowercaseCharacters}{Specifies whether IAM user passwords must contain at least one lowercase
character from the ISO basic Latin alphabet (a to z).

If you do not specify a value for this parameter, then the operation
uses the default value of \code{false}. The result is that passwords do not
require at least one lowercase character.}

\item{AllowUsersToChangePassword}{Allows all IAM users in your account to use the Amazon Web Services
Management Console to change their own passwords. For more information,
see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_enable-user-change.html}{Permitting IAM users to change their own passwords}
in the \emph{IAM User Guide}.

If you do not specify a value for this parameter, then the operation
uses the default value of \code{false}. The result is that IAM users in the
account do not automatically have permissions to change their own
password.}

\item{MaxPasswordAge}{The number of days that an IAM user password is valid.

If you do not specify a value for this parameter, then the operation
uses the default value of \code{0}. The result is that IAM user passwords
never expire.}

\item{PasswordReusePrevention}{Specifies the number of previous passwords that IAM users are prevented
from reusing.

If you do not specify a value for this parameter, then the operation
uses the default value of \code{0}. The result is that IAM users are not
prevented from reusing previous passwords.}

\item{HardExpiry}{Prevents IAM users who are accessing the account via the Amazon Web
Services Management Console from setting a new console password after
their password has expired. The IAM user cannot access the console until
an administrator resets the password.

If you do not specify a value for this parameter, then the operation
uses the default value of \code{false}. The result is that IAM users can
change their passwords after they expire and continue to sign in as the
user.

In the Amazon Web Services Management Console, the custom password
policy option \strong{Allow users to change their own password} gives IAM
users permissions to \code{iam:ChangePassword} for only their user and to the
\code{iam:GetAccountPasswordPolicy} action. This option does not attach a
permissions policy to each user, rather the permissions are applied at
the account-level for all users by IAM. IAM users with
\code{iam:ChangePassword} permission and active access keys can reset their
own expired console password using the CLI or API.}
}
\description{
Updates the password policy settings for the Amazon Web Services account.

See \url{https://paws-r.github.io/docs/iam/update_account_password_policy.html} for full documentation.
}
\keyword{internal}
