% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_list_saml_provider_tags}
\alias{iam_list_saml_provider_tags}
\title{Lists the tags that are attached to the specified Security Assertion
Markup Language (SAML) identity provider}
\usage{
iam_list_saml_provider_tags(SAMLProviderArn, Marker = NULL, MaxItems = NULL)
}
\arguments{
\item{SAMLProviderArn}{[required] The ARN of the Security Assertion Markup Language (SAML) identity
provider whose tags you want to see.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}
}
\description{
Lists the tags that are attached to the specified Security Assertion Markup Language (SAML) identity provider. The returned list of tags is sorted by tag key. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html}{About SAML 2.0-based federation}.

See \url{https://paws-r.github.io/docs/iam/list_saml_provider_tags.html} for full documentation.
}
\keyword{internal}
