% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_list_object_children}
\alias{clouddirectory_list_object_children}
\title{Returns a paginated list of child objects that are associated with a
given object}
\usage{
clouddirectory_list_object_children(
  DirectoryArn,
  ObjectReference,
  NextToken = NULL,
  MaxResults = NULL,
  ConsistencyLevel = NULL
)
}
\arguments{
\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) that is associated with the Directory
where the object resides. For more information, see arns.}

\item{ObjectReference}{[required] The reference that identifies the object for which child objects are
being listed.}

\item{NextToken}{The pagination token.}

\item{MaxResults}{The maximum number of items to be retrieved in a single call. This is an
approximate number.}

\item{ConsistencyLevel}{Represents the manner and timing in which the successful write or update
of an object is reflected in a subsequent read operation of that same
object.}
}
\description{
Returns a paginated list of child objects that are associated with a given object.

See \url{https://paws-r.github.io/docs/clouddirectory/list_object_children.html} for full documentation.
}
\keyword{internal}
