% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_attach_typed_link}
\alias{clouddirectory_attach_typed_link}
\title{Attaches a typed link to a specified source and target object}
\usage{
clouddirectory_attach_typed_link(
  DirectoryArn,
  SourceObjectReference,
  TargetObjectReference,
  TypedLinkFacet,
  Attributes
)
}
\arguments{
\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) of the directory where you want to attach
the typed link.}

\item{SourceObjectReference}{[required] Identifies the source object that the typed link will attach to.}

\item{TargetObjectReference}{[required] Identifies the target object that the typed link will attach to.}

\item{TypedLinkFacet}{[required] Identifies the typed link facet that is associated with the typed link.}

\item{Attributes}{[required] A set of attributes that are associated with the typed link.}
}
\description{
Attaches a typed link to a specified source and target object. For more information, see \href{https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink}{Typed Links}.

See \url{https://paws-r.github.io/docs/clouddirectory/attach_typed_link.html} for full documentation.
}
\keyword{internal}
