% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acm_operations.R
\name{acm_renew_certificate}
\alias{acm_renew_certificate}
\title{Renews an eligible ACM certificate}
\usage{
acm_renew_certificate(CertificateArn)
}
\arguments{
\item{CertificateArn}{[required] String that contains the ARN of the ACM certificate to be renewed. This
must be of the form:

\code{arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012}

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs)}.}
}
\description{
Renews an eligible ACM certificate. At this time, only exported private certificates can be renewed with this operation. In order to renew your ACM PCA certificates with ACM, you must first \href{https://docs.aws.amazon.com/privateca/latest/userguide/}{grant the ACM service principal permission to do so}. For more information, see \href{https://docs.aws.amazon.com/acm/latest/userguide/}{Testing Managed Renewal} in the ACM User Guide.

See \url{https://paws-r.github.io/docs/acm/renew_certificate.html} for full documentation.
}
\keyword{internal}
