% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_import_key_material}
\alias{kms_import_key_material}
\title{Imports key material into an existing symmetric AWS KMS customer master
key (CMK) that was created without key material}
\usage{
kms_import_key_material(KeyId, ImportToken, EncryptedKeyMaterial,
  ValidTo, ExpirationModel)
}
\arguments{
\item{KeyId}{[required] The identifier of the symmetric CMK that receives the imported key
material. The CMK\'s \code{Origin} must be \code{EXTERNAL}. This must be the same
CMK specified in the \code{KeyID} parameter of the corresponding
GetParametersForImport request.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{ImportToken}{[required] The import token that you received in the response to a previous
GetParametersForImport request. It must be from the same response that
contained the public key that you used to encrypt the key material.}

\item{EncryptedKeyMaterial}{[required] The encrypted key material to import. The key material must be encrypted
with the public wrapping key that GetParametersForImport returned, using
the wrapping algorithm that you specified in the same
\code{GetParametersForImport} request.}

\item{ValidTo}{The time at which the imported key material expires. When the key
material expires, AWS KMS deletes the key material and the CMK becomes
unusable. You must omit this parameter when the \code{ExpirationModel}
parameter is set to \code{KEY_MATERIAL_DOES_NOT_EXPIRE}. Otherwise it is
required.}

\item{ExpirationModel}{Specifies whether the key material expires. The default is
\code{KEY_MATERIAL_EXPIRES}, in which case you must include the \code{ValidTo}
parameter. When this parameter is set to \code{KEY_MATERIAL_DOES_NOT_EXPIRE},
you must omit the \code{ValidTo} parameter.}
}
\description{
Imports key material into an existing symmetric AWS KMS customer master
key (CMK) that was created without key material. After you successfully
import key material into a CMK, you can \href{https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html#reimport-key-material}{reimport the same key material}
into that CMK, but you cannot import different key material.
}
\details{
You cannot perform this operation on an asymmetric CMK or on any CMK in
a different AWS account. For more information about creating CMKs with
no key material and then importing key material, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html}{Importing Key Material}
in the \emph{AWS Key Management Service Developer Guide}.

Before using this operation, call GetParametersForImport. Its response
includes a public key and an import token. Use the public key to encrypt
the key material. Then, submit the import token from the same
\code{GetParametersForImport} response.

When calling this operation, you must specify the following values:
\itemize{
\item The key ID or key ARN of a CMK with no key material. Its \code{Origin}
must be \code{EXTERNAL}.

To create a CMK with no key material, call CreateKey and set the
value of its \code{Origin} parameter to \code{EXTERNAL}. To get the \code{Origin}
of a CMK, call DescribeKey.)
\item The encrypted key material. To get the public key to encrypt the key
material, call GetParametersForImport.
\item The import token that GetParametersForImport returned. You must use
a public key and token from the same \code{GetParametersForImport}
response.
\item Whether the key material expires and if so, when. If you set an
expiration date, AWS KMS deletes the key material from the CMK on
the specified date, and the CMK becomes unusable. To use the CMK
again, you must reimport the same key material. The only way to
change an expiration date is by reimporting the same key material
and specifying a new expiration date.
}

When this operation is successful, the key state of the CMK changes from
\code{PendingImport} to \code{Enabled}, and you can use the CMK.

If this operation fails, use the exception to help determine the
problem. If the error is related to the key material, the import token,
or wrapping key, use GetParametersForImport to get a new public key and
import token for the CMK and repeat the import procedure. For help, see
\href{https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html#importing-keys-overview}{How To Import Key Material}
in the \emph{AWS Key Management Service Developer Guide}.

The CMK that you use for this operation must be in a compatible key
state. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$import_key_material(
  KeyId = "string",
  ImportToken = raw,
  EncryptedKeyMaterial = raw,
  ValidTo = as.POSIXct(
    "2015-01-01"
  ),
  ExpirationModel = "KEY_MATERIAL_EXPIRES"|"KEY_MATERIAL_DOES_NOT_EXPIRE"
)
}
}

\examples{
\dontrun{
# The following example imports key material into the specified CMK.
svc$import_key_material(
  EncryptedKeyMaterial = "<binary data>",
  ExpirationModel = "KEY_MATERIAL_DOES_NOT_EXPIRE",
  ImportToken = "<binary data>",
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)
}

}
\keyword{internal}
