% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fms_operations.R
\name{fms_get_compliance_detail}
\alias{fms_get_compliance_detail}
\title{Returns detailed compliance information about the specified member
account}
\usage{
fms_get_compliance_detail(PolicyId, MemberAccount)
}
\arguments{
\item{PolicyId}{[required] The ID of the policy that you want to get the details for. \code{PolicyId} is
returned by \code{PutPolicy} and by \code{ListPolicies}.}

\item{MemberAccount}{[required] The AWS account that owns the resources that you want to get the details
for.}
}
\description{
Returns detailed compliance information about the specified member
account. Details include resources that are in and out of compliance
with the specified policy. Resources are considered noncompliant for AWS
WAF and Shield Advanced policies if the specified policy has not been
applied to them. Resources are considered noncompliant for security
group policies if they are in scope of the policy, they violate one or
more of the policy rules, and remediation is disabled or not possible.
}
\section{Request syntax}{
\preformatted{svc$get_compliance_detail(
  PolicyId = "string",
  MemberAccount = "string"
)
}
}

\keyword{internal}
