% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_get_policy}
\alias{iam_get_policy}
\title{Retrieves information about the specified managed policy, including the
policy's default version and the total number of IAM users, groups, and
roles to which the policy is attached}
\usage{
iam_get_policy(PolicyArn)
}
\arguments{
\item{PolicyArn}{[required] The Amazon Resource Name (ARN) of the managed policy that you want
information about.

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}
in the \emph{AWS General Reference}.}
}
\description{
Retrieves information about the specified managed policy, including the
policy's default version and the total number of IAM users, groups, and
roles to which the policy is attached. To retrieve the list of the
specific users, groups, and roles that the policy is attached to, use
the ListEntitiesForPolicy API. This API returns metadata about the
policy. To retrieve the actual policy document for a specific version of
the policy, use GetPolicyVersion.
}
\details{
This API retrieves information about managed policies. To retrieve
information about an inline policy that is embedded with an IAM user,
group, or role, use the GetUserPolicy, GetGroupPolicy, or GetRolePolicy
API.

For more information about policies, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html}{Managed Policies and Inline Policies}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_policy(
  PolicyArn = "string"
)
}
}

\keyword{internal}
