# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ram_service.R
NULL

#' Accepts an invitation to a resource share from another AWS account
#'
#' Accepts an invitation to a resource share from another AWS account.
#'
#' @usage
#' ram_accept_resource_share_invitation(resourceShareInvitationArn,
#'   clientToken)
#'
#' @param resourceShareInvitationArn &#91;required&#93; The Amazon Resource Name (ARN) of the invitation.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$accept_resource_share_invitation(
#'   resourceShareInvitationArn = "string",
#'   clientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_accept_resource_share_invitation
ram_accept_resource_share_invitation <- function(resourceShareInvitationArn, clientToken = NULL) {
  op <- new_operation(
    name = "AcceptResourceShareInvitation",
    http_method = "POST",
    http_path = "/acceptresourceshareinvitation",
    paginator = list()
  )
  input <- .ram$accept_resource_share_invitation_input(resourceShareInvitationArn = resourceShareInvitationArn, clientToken = clientToken)
  output <- .ram$accept_resource_share_invitation_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$accept_resource_share_invitation <- ram_accept_resource_share_invitation

#' Associates the specified resource share with the specified principals
#' and resources
#'
#' Associates the specified resource share with the specified principals
#' and resources.
#'
#' @usage
#' ram_associate_resource_share(resourceShareArn, resourceArns, principals,
#'   clientToken)
#'
#' @param resourceShareArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource share.
#' @param resourceArns The Amazon Resource Names (ARN) of the resources.
#' @param principals The principals.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$associate_resource_share(
#'   resourceShareArn = "string",
#'   resourceArns = list(
#'     "string"
#'   ),
#'   principals = list(
#'     "string"
#'   ),
#'   clientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_associate_resource_share
ram_associate_resource_share <- function(resourceShareArn, resourceArns = NULL, principals = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "AssociateResourceShare",
    http_method = "POST",
    http_path = "/associateresourceshare",
    paginator = list()
  )
  input <- .ram$associate_resource_share_input(resourceShareArn = resourceShareArn, resourceArns = resourceArns, principals = principals, clientToken = clientToken)
  output <- .ram$associate_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$associate_resource_share <- ram_associate_resource_share

#' Creates a resource share
#'
#' Creates a resource share.
#'
#' @usage
#' ram_create_resource_share(name, resourceArns, principals, tags,
#'   allowExternalPrincipals, clientToken)
#'
#' @param name &#91;required&#93; The name of the resource share.
#' @param resourceArns The Amazon Resource Names (ARN) of the resources to associate with the
#' resource share.
#' @param principals The principals to associate with the resource share. The possible values
#' are IDs of AWS accounts, the ARN of an OU or organization from AWS
#' Organizations.
#' @param tags One or more tags.
#' @param allowExternalPrincipals Indicates whether principals outside your organization can be associated
#' with a resource share.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$create_resource_share(
#'   name = "string",
#'   resourceArns = list(
#'     "string"
#'   ),
#'   principals = list(
#'     "string"
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   allowExternalPrincipals = TRUE|FALSE,
#'   clientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_create_resource_share
ram_create_resource_share <- function(name, resourceArns = NULL, principals = NULL, tags = NULL, allowExternalPrincipals = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "CreateResourceShare",
    http_method = "POST",
    http_path = "/createresourceshare",
    paginator = list()
  )
  input <- .ram$create_resource_share_input(name = name, resourceArns = resourceArns, principals = principals, tags = tags, allowExternalPrincipals = allowExternalPrincipals, clientToken = clientToken)
  output <- .ram$create_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$create_resource_share <- ram_create_resource_share

#' Deletes the specified resource share
#'
#' Deletes the specified resource share.
#'
#' @usage
#' ram_delete_resource_share(resourceShareArn, clientToken)
#'
#' @param resourceShareArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource share.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$delete_resource_share(
#'   resourceShareArn = "string",
#'   clientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_delete_resource_share
ram_delete_resource_share <- function(resourceShareArn, clientToken = NULL) {
  op <- new_operation(
    name = "DeleteResourceShare",
    http_method = "DELETE",
    http_path = "/deleteresourceshare",
    paginator = list()
  )
  input <- .ram$delete_resource_share_input(resourceShareArn = resourceShareArn, clientToken = clientToken)
  output <- .ram$delete_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$delete_resource_share <- ram_delete_resource_share

#' Disassociates the specified principals or resources from the specified
#' resource share
#'
#' Disassociates the specified principals or resources from the specified
#' resource share.
#'
#' @usage
#' ram_disassociate_resource_share(resourceShareArn, resourceArns,
#'   principals, clientToken)
#'
#' @param resourceShareArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource share.
#' @param resourceArns The Amazon Resource Names (ARN) of the resources.
#' @param principals The principals.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_resource_share(
#'   resourceShareArn = "string",
#'   resourceArns = list(
#'     "string"
#'   ),
#'   principals = list(
#'     "string"
#'   ),
#'   clientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_disassociate_resource_share
ram_disassociate_resource_share <- function(resourceShareArn, resourceArns = NULL, principals = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "DisassociateResourceShare",
    http_method = "POST",
    http_path = "/disassociateresourceshare",
    paginator = list()
  )
  input <- .ram$disassociate_resource_share_input(resourceShareArn = resourceShareArn, resourceArns = resourceArns, principals = principals, clientToken = clientToken)
  output <- .ram$disassociate_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$disassociate_resource_share <- ram_disassociate_resource_share

#' Enables resource sharing within your organization
#'
#' Enables resource sharing within your organization.
#'
#' @usage
#' ram_enable_sharing_with_aws_organization()
#'
#' @section Request syntax:
#' ```
#' svc$enable_sharing_with_aws_organization()
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_enable_sharing_with_aws_organization
ram_enable_sharing_with_aws_organization <- function() {
  op <- new_operation(
    name = "EnableSharingWithAwsOrganization",
    http_method = "POST",
    http_path = "/enablesharingwithawsorganization",
    paginator = list()
  )
  input <- .ram$enable_sharing_with_aws_organization_input()
  output <- .ram$enable_sharing_with_aws_organization_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$enable_sharing_with_aws_organization <- ram_enable_sharing_with_aws_organization

#' Gets the policies for the specifies resources
#'
#' Gets the policies for the specifies resources.
#'
#' @usage
#' ram_get_resource_policies(resourceArns, principal, nextToken,
#'   maxResults)
#'
#' @param resourceArns &#91;required&#93; The Amazon Resource Names (ARN) of the resources.
#' @param principal The principal.
#' @param nextToken The token for the next page of results.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$get_resource_policies(
#'   resourceArns = list(
#'     "string"
#'   ),
#'   principal = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_get_resource_policies
ram_get_resource_policies <- function(resourceArns, principal = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetResourcePolicies",
    http_method = "POST",
    http_path = "/getresourcepolicies",
    paginator = list()
  )
  input <- .ram$get_resource_policies_input(resourceArns = resourceArns, principal = principal, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$get_resource_policies_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$get_resource_policies <- ram_get_resource_policies

#' Gets the associations for the specified resource share
#'
#' Gets the associations for the specified resource share.
#'
#' @usage
#' ram_get_resource_share_associations(associationType, resourceShareArns,
#'   resourceArn, principal, associationStatus, nextToken, maxResults)
#'
#' @param associationType &#91;required&#93; The association type.
#' @param resourceShareArns The Amazon Resource Names (ARN) of the resource shares.
#' @param resourceArn The Amazon Resource Name (ARN) of the resource.
#' @param principal The principal.
#' @param associationStatus The status of the association.
#' @param nextToken The token for the next page of results.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$get_resource_share_associations(
#'   associationType = "PRINCIPAL"|"RESOURCE",
#'   resourceShareArns = list(
#'     "string"
#'   ),
#'   resourceArn = "string",
#'   principal = "string",
#'   associationStatus = "ASSOCIATING"|"ASSOCIATED"|"FAILED"|"DISASSOCIATING"|"DISASSOCIATED",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_get_resource_share_associations
ram_get_resource_share_associations <- function(associationType, resourceShareArns = NULL, resourceArn = NULL, principal = NULL, associationStatus = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetResourceShareAssociations",
    http_method = "POST",
    http_path = "/getresourceshareassociations",
    paginator = list()
  )
  input <- .ram$get_resource_share_associations_input(associationType = associationType, resourceShareArns = resourceShareArns, resourceArn = resourceArn, principal = principal, associationStatus = associationStatus, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$get_resource_share_associations_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$get_resource_share_associations <- ram_get_resource_share_associations

#' Gets the specified invitations for resource sharing
#'
#' Gets the specified invitations for resource sharing.
#'
#' @usage
#' ram_get_resource_share_invitations(resourceShareInvitationArns,
#'   resourceShareArns, nextToken, maxResults)
#'
#' @param resourceShareInvitationArns The Amazon Resource Names (ARN) of the invitations.
#' @param resourceShareArns The Amazon Resource Names (ARN) of the resource shares.
#' @param nextToken The token for the next page of results.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$get_resource_share_invitations(
#'   resourceShareInvitationArns = list(
#'     "string"
#'   ),
#'   resourceShareArns = list(
#'     "string"
#'   ),
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_get_resource_share_invitations
ram_get_resource_share_invitations <- function(resourceShareInvitationArns = NULL, resourceShareArns = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetResourceShareInvitations",
    http_method = "POST",
    http_path = "/getresourceshareinvitations",
    paginator = list()
  )
  input <- .ram$get_resource_share_invitations_input(resourceShareInvitationArns = resourceShareInvitationArns, resourceShareArns = resourceShareArns, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$get_resource_share_invitations_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$get_resource_share_invitations <- ram_get_resource_share_invitations

#' Gets the specified resource shares or all of your resource shares
#'
#' Gets the specified resource shares or all of your resource shares.
#'
#' @usage
#' ram_get_resource_shares(resourceShareArns, resourceShareStatus,
#'   resourceOwner, name, tagFilters, nextToken, maxResults)
#'
#' @param resourceShareArns The Amazon Resource Names (ARN) of the resource shares.
#' @param resourceShareStatus The status of the resource share.
#' @param resourceOwner &#91;required&#93; The type of owner.
#' @param name The name of the resource share.
#' @param tagFilters One or more tag filters.
#' @param nextToken The token for the next page of results.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$get_resource_shares(
#'   resourceShareArns = list(
#'     "string"
#'   ),
#'   resourceShareStatus = "PENDING"|"ACTIVE"|"FAILED"|"DELETING"|"DELETED",
#'   resourceOwner = "SELF"|"OTHER-ACCOUNTS",
#'   name = "string",
#'   tagFilters = list(
#'     list(
#'       tagKey = "string",
#'       tagValues = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_get_resource_shares
ram_get_resource_shares <- function(resourceShareArns = NULL, resourceShareStatus = NULL, resourceOwner, name = NULL, tagFilters = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetResourceShares",
    http_method = "POST",
    http_path = "/getresourceshares",
    paginator = list()
  )
  input <- .ram$get_resource_shares_input(resourceShareArns = resourceShareArns, resourceShareStatus = resourceShareStatus, resourceOwner = resourceOwner, name = name, tagFilters = tagFilters, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$get_resource_shares_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$get_resource_shares <- ram_get_resource_shares

#' Lists the principals with access to the specified resource
#'
#' Lists the principals with access to the specified resource.
#'
#' @usage
#' ram_list_principals(resourceOwner, resourceArn, principals,
#'   resourceType, resourceShareArns, nextToken, maxResults)
#'
#' @param resourceOwner &#91;required&#93; The type of owner.
#' @param resourceArn The Amazon Resource Name (ARN) of the resource.
#' @param principals The principals.
#' @param resourceType The resource type.
#' @param resourceShareArns The Amazon Resource Names (ARN) of the resource shares.
#' @param nextToken The token for the next page of results.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$list_principals(
#'   resourceOwner = "SELF"|"OTHER-ACCOUNTS",
#'   resourceArn = "string",
#'   principals = list(
#'     "string"
#'   ),
#'   resourceType = "string",
#'   resourceShareArns = list(
#'     "string"
#'   ),
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_list_principals
ram_list_principals <- function(resourceOwner, resourceArn = NULL, principals = NULL, resourceType = NULL, resourceShareArns = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListPrincipals",
    http_method = "POST",
    http_path = "/listprincipals",
    paginator = list()
  )
  input <- .ram$list_principals_input(resourceOwner = resourceOwner, resourceArn = resourceArn, principals = principals, resourceType = resourceType, resourceShareArns = resourceShareArns, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$list_principals_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_principals <- ram_list_principals

#' Lists the resources that the specified principal can access
#'
#' Lists the resources that the specified principal can access.
#'
#' @usage
#' ram_list_resources(resourceOwner, principal, resourceType, resourceArns,
#'   resourceShareArns, nextToken, maxResults)
#'
#' @param resourceOwner &#91;required&#93; The type of owner.
#' @param principal The principal.
#' @param resourceType The resource type.
#' @param resourceArns The Amazon Resource Names (ARN) of the resources.
#' @param resourceShareArns The Amazon Resource Names (ARN) of the resource shares.
#' @param nextToken The token for the next page of results.
#' @param maxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$list_resources(
#'   resourceOwner = "SELF"|"OTHER-ACCOUNTS",
#'   principal = "string",
#'   resourceType = "string",
#'   resourceArns = list(
#'     "string"
#'   ),
#'   resourceShareArns = list(
#'     "string"
#'   ),
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_list_resources
ram_list_resources <- function(resourceOwner, principal = NULL, resourceType = NULL, resourceArns = NULL, resourceShareArns = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListResources",
    http_method = "POST",
    http_path = "/listresources",
    paginator = list()
  )
  input <- .ram$list_resources_input(resourceOwner = resourceOwner, principal = principal, resourceType = resourceType, resourceArns = resourceArns, resourceShareArns = resourceShareArns, nextToken = nextToken, maxResults = maxResults)
  output <- .ram$list_resources_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$list_resources <- ram_list_resources

#' Rejects an invitation to a resource share from another AWS account
#'
#' Rejects an invitation to a resource share from another AWS account.
#'
#' @usage
#' ram_reject_resource_share_invitation(resourceShareInvitationArn,
#'   clientToken)
#'
#' @param resourceShareInvitationArn &#91;required&#93; The Amazon Resource Name (ARN) of the invitation.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$reject_resource_share_invitation(
#'   resourceShareInvitationArn = "string",
#'   clientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_reject_resource_share_invitation
ram_reject_resource_share_invitation <- function(resourceShareInvitationArn, clientToken = NULL) {
  op <- new_operation(
    name = "RejectResourceShareInvitation",
    http_method = "POST",
    http_path = "/rejectresourceshareinvitation",
    paginator = list()
  )
  input <- .ram$reject_resource_share_invitation_input(resourceShareInvitationArn = resourceShareInvitationArn, clientToken = clientToken)
  output <- .ram$reject_resource_share_invitation_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$reject_resource_share_invitation <- ram_reject_resource_share_invitation

#' Adds the specified tags to the specified resource share
#'
#' Adds the specified tags to the specified resource share.
#'
#' @usage
#' ram_tag_resource(resourceShareArn, tags)
#'
#' @param resourceShareArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource share.
#' @param tags &#91;required&#93; One or more tags.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   resourceShareArn = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_tag_resource
ram_tag_resource <- function(resourceShareArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tagresource",
    paginator = list()
  )
  input <- .ram$tag_resource_input(resourceShareArn = resourceShareArn, tags = tags)
  output <- .ram$tag_resource_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$tag_resource <- ram_tag_resource

#' Removes the specified tags from the specified resource share
#'
#' Removes the specified tags from the specified resource share.
#'
#' @usage
#' ram_untag_resource(resourceShareArn, tagKeys)
#'
#' @param resourceShareArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource share.
#' @param tagKeys &#91;required&#93; The tag keys of the tags to remove.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   resourceShareArn = "string",
#'   tagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_untag_resource
ram_untag_resource <- function(resourceShareArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/untagresource",
    paginator = list()
  )
  input <- .ram$untag_resource_input(resourceShareArn = resourceShareArn, tagKeys = tagKeys)
  output <- .ram$untag_resource_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$untag_resource <- ram_untag_resource

#' Updates the specified resource share
#'
#' Updates the specified resource share.
#'
#' @usage
#' ram_update_resource_share(resourceShareArn, name,
#'   allowExternalPrincipals, clientToken)
#'
#' @param resourceShareArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource share.
#' @param name The name of the resource share.
#' @param allowExternalPrincipals Indicates whether principals outside your organization can be associated
#' with a resource share.
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$update_resource_share(
#'   resourceShareArn = "string",
#'   name = "string",
#'   allowExternalPrincipals = TRUE|FALSE,
#'   clientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ram_update_resource_share
ram_update_resource_share <- function(resourceShareArn, name = NULL, allowExternalPrincipals = NULL, clientToken = NULL) {
  op <- new_operation(
    name = "UpdateResourceShare",
    http_method = "POST",
    http_path = "/updateresourceshare",
    paginator = list()
  )
  input <- .ram$update_resource_share_input(resourceShareArn = resourceShareArn, name = name, allowExternalPrincipals = allowExternalPrincipals, clientToken = clientToken)
  output <- .ram$update_resource_share_output()
  config <- get_config()
  svc <- .ram$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ram$operations$update_resource_share <- ram_update_resource_share
