% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fms_operations.R
\name{fms_put_policy}
\alias{fms_put_policy}
\title{Creates an AWS Firewall Manager policy}
\usage{
fms_put_policy(Policy)
}
\arguments{
\item{Policy}{[required] The details of the AWS Firewall Manager policy to be created.}
}
\description{
Creates an AWS Firewall Manager policy.
}
\details{
Firewall Manager provides two types of policies: A Shield Advanced
policy, which applies Shield Advanced protection to specified accounts
and resources, or a WAF policy, which contains a rule group and defines
which resources are to be protected by that rule group. A policy is
specific to either WAF or Shield Advanced. If you want to enforce both
WAF rules and Shield Advanced protection across accounts, you can create
multiple policies. You can create one or more policies for WAF rules,
and one or more policies for Shield Advanced.

You must be subscribed to Shield Advanced to create a Shield Advanced
policy. For more information on subscribing to Shield Advanced, see
\href{https://docs.aws.amazon.com/waf/latest/DDOSAPIReference/API_CreateSubscription.html}{CreateSubscription}.
}
\section{Request syntax}{
\preformatted{svc$put_policy(
  Policy = list(
    PolicyId = "string",
    PolicyName = "string",
    PolicyUpdateToken = "string",
    SecurityServicePolicyData = list(
      Type = "WAF"|"SHIELD_ADVANCED",
      ManagedServiceData = "string"
    ),
    ResourceType = "string",
    ResourceTypeList = list(
      "string"
    ),
    ResourceTags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    ExcludeResourceTags = TRUE|FALSE,
    RemediationEnabled = TRUE|FALSE,
    IncludeMap = list(
      list(
        "string"
      )
    ),
    ExcludeMap = list(
      list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
