% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_invite_members}
\alias{guardduty_invite_members}
\title{Invites other AWS accounts (created as members of the current AWS
account by CreateMembers) to enable GuardDuty, and allow the current AWS
account to view and manage these accounts' findings on their behalf as
the GuardDuty administrator account}
\usage{
guardduty_invite_members(DetectorId, AccountIds,
  DisableEmailNotification, Message)
}
\arguments{
\item{DetectorId}{[required] The unique ID of the detector of the GuardDuty account that you want to
invite members with.}

\item{AccountIds}{[required] A list of account IDs of the accounts that you want to invite to
GuardDuty as members.}

\item{DisableEmailNotification}{A Boolean value that specifies whether you want to disable email
notification to the accounts that you are inviting to GuardDuty as
members.}

\item{Message}{The invitation message that you want to send to the accounts that you're
inviting to GuardDuty as members.}
}
\value{
A list with the following syntax:\preformatted{list(
  UnprocessedAccounts = list(
    list(
      AccountId = "string",
      Result = "string"
    )
  )
)
}
}
\description{
Invites other AWS accounts (created as members of the current AWS
account by CreateMembers) to enable GuardDuty, and allow the current AWS
account to view and manage these accounts' findings on their behalf as
the GuardDuty administrator account.
}
\section{Request syntax}{
\preformatted{svc$invite_members(
  DetectorId = "string",
  AccountIds = list(
    "string"
  ),
  DisableEmailNotification = TRUE|FALSE,
  Message = "string"
)
}
}

\keyword{internal}
