% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fms_operations.R
\name{fms_list_protocols_lists}
\alias{fms_list_protocols_lists}
\title{Returns an array of ProtocolsListDataSummary objects}
\usage{
fms_list_protocols_lists(DefaultLists, NextToken, MaxResults)
}
\arguments{
\item{DefaultLists}{Specifies whether the lists to retrieve are default lists owned by AWS
Firewall Manager.}

\item{NextToken}{If you specify a value for \code{MaxResults} in your list request, and you
have more objects than the maximum, AWS Firewall Manager returns this
token in the response. For all but the first request, you provide the
token returned by the prior request in the request parameters, to
retrieve the next batch of objects.}

\item{MaxResults}{[required] The maximum number of objects that you want AWS Firewall Manager to
return for this request. If more objects are available, in the response,
AWS Firewall Manager provides a \code{NextToken} value that you can use in a
subsequent call to get the next batch of objects.

If you don't specify this, AWS Firewall Manager returns all available
objects.}
}
\value{
A list with the following syntax:\preformatted{list(
  ProtocolsLists = list(
    list(
      ListArn = "string",
      ListId = "string",
      ListName = "string",
      ProtocolsList = list(
        "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns an array of \code{ProtocolsListDataSummary} objects.
}
\section{Request syntax}{
\preformatted{svc$list_protocols_lists(
  DefaultLists = TRUE|FALSE,
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
