% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shield_operations.R
\name{shield_list_resources_in_protection_group}
\alias{shield_list_resources_in_protection_group}
\title{Retrieves the resources that are included in the protection group}
\usage{
shield_list_resources_in_protection_group(ProtectionGroupId, NextToken,
  MaxResults)
}
\arguments{
\item{ProtectionGroupId}{[required] The name of the protection group. You use this to identify the
protection group in lists and to manage the protection group, for
example to update, delete, or describe it.}

\item{NextToken}{The next token value from a previous call to
\code{ListResourcesInProtectionGroup}. Pass null if this is the first call.}

\item{MaxResults}{The maximum number of resource ARN objects to return. If you leave this
blank, Shield Advanced returns the first 20 results.

This is a maximum value. Shield Advanced might return the results in
smaller batches. That is, the number of objects returned could be less
than \code{MaxResults}, even if there are still more objects yet to return.
If there are more objects to return, Shield Advanced returns a value in
\code{NextToken} that you can use in your next request, to get the next batch
of objects.}
}
\description{
Retrieves the resources that are included in the protection group.
}
\section{Request syntax}{
\preformatted{svc$list_resources_in_protection_group(
  ProtectionGroupId = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
