% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_login_profile}
\alias{iam_update_login_profile}
\title{Changes the password for the specified IAM user}
\usage{
iam_update_login_profile(UserName, Password, PasswordResetRequired)
}
\arguments{
\item{UserName}{[required] The name of the user whose password you want to update.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}

\item{Password}{The new password for the specified IAM user.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} used to
validate this parameter is a string of characters consisting of the
following:
\itemize{
\item Any printable ASCII character ranging from the space character
(\code{U+0020}) through the end of the ASCII character range
\item The printable characters in the Basic Latin and Latin-1 Supplement
character set (through \verb{U+00FF})
\item The special characters tab (\code{U+0009}), line feed (\verb{U+000A}), and
carriage return (\verb{U+000D})
}

However, the format can be further restricted by the account
administrator by setting a password policy on the AWS account. For more
information, see UpdateAccountPasswordPolicy.}

\item{PasswordResetRequired}{Allows this new password to be used only once by requiring the specified
IAM user to set a new password on next sign-in.}
}
\description{
Changes the password for the specified IAM user.

IAM users can change their own passwords by calling ChangePassword. For
more information about modifying passwords, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_admin-change-user.html}{Managing Passwords}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_login_profile(
  UserName = "string",
  Password = "string",
  PasswordResetRequired = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# The following command creates or changes the password for the IAM user
# named Bob.
svc$update_login_profile(
  Password = "SomeKindOfPassword123!@#",
  UserName = "Bob"
)
}

}
\keyword{internal}
