% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_operations.R
\name{sts_assume_role}
\alias{sts_assume_role}
\title{Returns a set of temporary security credentials (consisting of an access
key ID, a secret access key, and a security token) that you can use to
access AWS resources that you might not normally have access to}
\usage{
sts_assume_role(RoleArn, RoleSessionName, Policy, DurationSeconds,
  ExternalId, SerialNumber, TokenCode)
}
\arguments{
\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the role to assume.}

\item{RoleSessionName}{[required] An identifier for the assumed role session.

Use the role session name to uniquely identify a session when the same
role is assumed by different principals or for different reasons. In
cross-account scenarios, the role session name is visible to, and can be
logged by the account that owns the role. The role session name is also
used in the ARN of the assumed role principal. This means that
subsequent cross-account API requests using the temporary security
credentials will expose the role session name to the external account in
their CloudTrail logs.

The regex used to validate this parameter is a string of characters
consisting of upper- and lower-case alphanumeric characters with no
spaces. You can also include underscores or any of the following
characters: =,.@-}

\item{Policy}{An IAM policy in JSON format.

This parameter is optional. If you pass a policy, the temporary security
credentials that are returned by the operation have the permissions that
are allowed by both (the intersection of) the access policy of the role
that is being assumed, \emph{and} the policy that you pass. This gives you a
way to further restrict the permissions for the resulting temporary
security credentials. You cannot use the passed policy to grant
permissions that are in excess of those allowed by the access policy of
the role that is being assumed. For more information, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html}{Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity}
in the \emph{IAM User Guide}.

The format for this parameter, as described by its regex pattern, is a
string of characters up to 2048 characters in length. The characters can
be any ASCII character from the space character to the end of the valid
character list (\code{U+0020}-\code{U+00FF}). It can also include the tab (\code{U+0009}),
linefeed (\code{U+000A}), and carriage return (\code{U+000D}) characters.

The policy plain text must be 2048 bytes or shorter. However, an
internal conversion compresses it into a packed binary format with a
separate limit. The PackedPolicySize response element indicates by
percentage how close to the upper size limit the policy is, with 100\%
equaling the maximum allowed size.}

\item{DurationSeconds}{The duration, in seconds, of the role session. The value can range from
900 seconds (15 minutes) up to the maximum session duration setting for
the role. This setting can have a value from 1 hour to 12 hours. If you
specify a value higher than this setting, the operation fails. For
example, if you specify a session duration of 12 hours, but your
administrator set the maximum session duration to 6 hours, your
operation fails. To learn how to view the maximum value for your role,
see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session}{View the Maximum Session Duration Setting for a Role}
in the \emph{IAM User Guide}.

By default, the value is set to 3600 seconds.

The \code{DurationSeconds} parameter is separate from the duration of a
console session that you might request using the returned credentials.
The request to the federation endpoint for a console sign-in token takes
a \code{SessionDuration} parameter that specifies the maximum length of the
console session. For more information, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html}{Creating a URL that Enables Federated Users to Access the AWS Management Console}
in the \emph{IAM User Guide}.}

\item{ExternalId}{A unique identifier that is used by third parties when assuming roles in
their customers' accounts. For each role that the third party can
assume, they should instruct their customers to ensure the role's trust
policy checks for the external ID that the third party generated. Each
time the third party assumes the role, they should pass the customer's
external ID. The external ID is useful in order to help third parties
bind a role to the customer who created it. For more information about
the external ID, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html}{How to Use an External ID When Granting Access to Your AWS Resources to a Third Party}
in the \emph{IAM User Guide}.

The regex used to validated this parameter is a string of characters
consisting of upper- and lower-case alphanumeric characters with no
spaces. You can also include underscores or any of the following
characters: =,.@:/-}

\item{SerialNumber}{The identification number of the MFA device that is associated with the
user who is making the \code{AssumeRole} call. Specify this value if the
trust policy of the role being assumed includes a condition that
requires MFA authentication. The value is either the serial number for a
hardware device (such as \code{GAHT12345678}) or an Amazon Resource Name
(ARN) for a virtual device (such as
\code{arn:aws:iam::123456789012:mfa/user}).

The regex used to validate this parameter is a string of characters
consisting of upper- and lower-case alphanumeric characters with no
spaces. You can also include underscores or any of the following
characters: =,.@-}

\item{TokenCode}{The value provided by the MFA device, if the trust policy of the role
being assumed requires MFA (that is, if the policy includes a condition
that tests for MFA). If the role being assumed requires MFA and if the
\code{TokenCode} value is missing or expired, the \code{AssumeRole} call returns
an "access denied" error.

The format for this parameter, as described by its regex pattern, is a
sequence of six numeric digits.}
}
\description{
Returns a set of temporary security credentials (consisting of an access
key ID, a secret access key, and a security token) that you can use to
access AWS resources that you might not normally have access to.
Typically, you use \code{AssumeRole} for cross-account access or federation.
For a comparison of \code{AssumeRole} with the other APIs that produce
temporary credentials, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html}{Requesting Temporary Security Credentials}
and \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison}{Comparing the AWS STS APIs}
in the \emph{IAM User Guide}.
}
\details{
\strong{Important:} You cannot call \code{AssumeRole} by using AWS root account
credentials; access is denied. You must use credentials for an IAM user
or an IAM role to call \code{AssumeRole}.

For cross-account access, imagine that you own multiple accounts and
need to access resources in each account. You could create long-term
credentials in each account to access those resources. However, managing
all those credentials and remembering which one can access which account
can be time consuming. Instead, you can create one set of long-term
credentials in one account and then use temporary security credentials
to access all the other accounts by assuming roles in those accounts.
For more information about roles, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html}{IAM Roles (Delegation and Federation)}
in the \emph{IAM User Guide}.

For federation, you can, for example, grant single sign-on access to the
AWS Management Console. If you already have an identity and
authentication system in your corporate network, you don't have to
recreate user identities in AWS in order to grant those user identities
access to AWS. Instead, after a user has been authenticated, you call
\code{AssumeRole} (and specify the role with the appropriate permissions) to
get temporary security credentials for that user. With those temporary
security credentials, you construct a sign-in URL that users can use to
access the console. For more information, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp.html#sts-introduction}{Common Scenarios for Temporary Credentials}
in the \emph{IAM User Guide}.

By default, the temporary security credentials created by \code{AssumeRole}
last for one hour. However, you can use the optional \code{DurationSeconds}
parameter to specify the duration of your session. You can provide a
value from 900 seconds (15 minutes) up to the maximum session duration
setting for the role. This setting can have a value from 1 hour to 12
hours. To learn how to view the maximum value for your role, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session}{View the Maximum Session Duration Setting for a Role}
in the \emph{IAM User Guide}. The maximum session duration limit applies when
you use the \code{AssumeRole*} API operations or the \code{assume-role*} CLI
operations but does not apply when you use those operations to create a
console URL. For more information, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html}{Using IAM Roles}
in the \emph{IAM User Guide}.

The temporary security credentials created by \code{AssumeRole} can be used
to make API calls to any AWS service with the following exception: you
cannot call the STS service's \code{GetFederationToken} or \code{GetSessionToken}
APIs.

Optionally, you can pass an IAM access policy to this operation. If you
choose not to pass a policy, the temporary security credentials that are
returned by the operation have the permissions that are defined in the
access policy of the role that is being assumed. If you pass a policy to
this operation, the temporary security credentials that are returned by
the operation have the permissions that are allowed by both the access
policy of the role that is being assumed, \emph{\strong{and}} the policy that you
pass. This gives you a way to further restrict the permissions for the
resulting temporary security credentials. You cannot use the passed
policy to grant permissions that are in excess of those allowed by the
access policy of the role that is being assumed. For more information,
see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_assumerole.html}{Permissions for AssumeRole, AssumeRoleWithSAML, and AssumeRoleWithWebIdentity}
in the \emph{IAM User Guide}.

To assume a role, your AWS account must be trusted by the role. The
trust relationship is defined in the role's trust policy when the role
is created. That trust policy states which accounts are allowed to
delegate access to this account's role.

The user who wants to access the role must also have permissions
delegated from the role's administrator. If the user is in a different
account than the role, then the user's administrator must attach a
policy that allows the user to call AssumeRole on the ARN of the role in
the other account. If the user is in the same account as the role, then
you can either attach a policy to the user (identical to the previous
different account user), or you can add the user as a principal directly
in the role's trust policy. In this case, the trust policy acts as the
only resource-based policy in IAM, and users in the same account as the
role do not need explicit permission to assume the role. For more
information about trust policies and resource-based policies, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html}{IAM Policies}
in the \emph{IAM User Guide}.

\strong{Using MFA with AssumeRole}

You can optionally include multi-factor authentication (MFA) information
when you call \code{AssumeRole}. This is useful for cross-account scenarios
in which you want to make sure that the user who is assuming the role
has been authenticated using an AWS MFA device. In that scenario, the
trust policy of the role being assumed includes a condition that tests
for MFA authentication; if the caller does not include valid MFA
information, the request to assume the role is denied. The condition in
a trust policy that tests for MFA authentication might look like the
following example.

\code{"Condition": \{"Bool": \{"aws:MultiFactorAuthPresent": true\}\}}

For more information, see \href{http://docs.aws.amazon.com/IAM/latest/UserGuide/MFAProtectedAPI.html}{Configuring MFA-Protected API Access}
in the \emph{IAM User Guide} guide.

To use MFA with \code{AssumeRole}, you pass values for the \code{SerialNumber} and
\code{TokenCode} parameters. The \code{SerialNumber} value identifies the user's
hardware or virtual MFA device. The \code{TokenCode} is the time-based
one-time password (TOTP) that the MFA devices produces.
}
\section{Request syntax}{
\preformatted{svc$assume_role(
  RoleArn = "string",
  RoleSessionName = "string",
  Policy = "string",
  DurationSeconds = 123,
  ExternalId = "string",
  SerialNumber = "string",
  TokenCode = "string"
)
}
}

\examples{
# 
\donttest{svc$assume_role(
  DurationSeconds = 3600L,
  ExternalId = "123ABC",
  Policy = "{\\"Version\\":\\"2012-10-17\\",\\"Statement\\":[{\\"Sid\\":\\"Stmt1\\",\\"Effect\\":...",
  RoleArn = "arn:aws:iam::123456789012:role/demo",
  RoleSessionName = "Bob"
)}

}
\keyword{internal}
