% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_update_alias}
\alias{kms_update_alias}
\title{Associates an existing alias with a different customer master key (CMK)}
\usage{
kms_update_alias(AliasName, TargetKeyId)
}
\arguments{
\item{AliasName}{[required] String that contains the name of the alias to be modified. The name must
start with the word "alias" followed by a forward slash (alias/).
Aliases that begin with "alias/aws" are reserved.}

\item{TargetKeyId}{[required] Unique identifier of the customer master key to be mapped to the alias.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.

To verify that the alias is mapped to the correct CMK, use ListAliases.}
}
\description{
Associates an existing alias with a different customer master key (CMK).
Each CMK can have multiple aliases, but the aliases must be unique
within the account and region. You cannot perform this operation on an
alias in a different AWS account.
}
\details{
This operation works only on existing aliases. To change the alias of a
CMK to a new value, use CreateAlias to create a new alias and
DeleteAlias to delete the old alias.

Because an alias is not a property of a CMK, you can create, update, and
delete the aliases of a CMK without affecting the CMK. Also, aliases do
not appear in the response from the DescribeKey operation. To get the
aliases of all CMKs in the account, use the ListAliases operation.

An alias name can contain only alphanumeric characters, forward slashes
(/), underscores (\_), and dashes (-). An alias must start with the word
\code{alias} followed by a forward slash (\code{alias/}). The alias name can
contain only alphanumeric characters, forward slashes (/), underscores
(\_), and dashes (-). Alias names cannot begin with \code{aws}; that alias
name prefix is reserved by Amazon Web Services (AWS).

The result of this operation varies with the key state of the CMK. For
details, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_alias(
  AliasName = "string",
  TargetKeyId = "string"
)
}
}

\examples{
# The following example updates the specified alias to refer to the
# specified customer master key (CMK).
\donttest{svc$update_alias(
  AliasName = "alias/ExampleAlias",
  TargetKeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)}

}
\keyword{internal}
