% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_create_hosted_zone}
\alias{route53_create_hosted_zone}
\title{Creates a new public or private hosted zone}
\usage{
route53_create_hosted_zone(
  Name,
  VPC = NULL,
  CallerReference,
  HostedZoneConfig = NULL,
  DelegationSetId = NULL
)
}
\arguments{
\item{Name}{[required] The name of the domain. Specify a fully qualified domain name, for
example, \emph{www.example.com}. The trailing dot is optional; Amazon
Route 53 assumes that the domain name is fully qualified. This means
that Route 53 treats \emph{www.example.com} (without a trailing dot) and
\emph{www.example.com.} (with a trailing dot) as identical.

If you're creating a public hosted zone, this is the name you have
registered with your DNS registrar. If your domain name is registered
with a registrar other than Route 53, change the name servers for your
domain to the set of \code{NameServers} that
\code{\link[=route53_create_hosted_zone]{create_hosted_zone}} returns in
\code{DelegationSet}.}

\item{VPC}{(Private hosted zones only) A complex type that contains information
about the Amazon VPC that you're associating with this hosted zone.

You can specify only one Amazon VPC when you create a private hosted
zone. If you are associating a VPC with a hosted zone with this request,
the paramaters \code{VPCId} and \code{VPCRegion} are also required.

To associate additional Amazon VPCs with the hosted zone, use
\code{\link[=route53_associate_vpc_with_hosted_zone]{associate_vpc_with_hosted_zone}}
after you create a hosted zone.}

\item{CallerReference}{[required] A unique string that identifies the request and that allows failed
\code{\link[=route53_create_hosted_zone]{create_hosted_zone}} requests to be
retried without the risk of executing the operation twice. You must use
a unique \code{CallerReference} string every time you submit a
\code{\link[=route53_create_hosted_zone]{create_hosted_zone}} request.
\code{CallerReference} can be any unique string, for example, a date/time
stamp.}

\item{HostedZoneConfig}{(Optional) A complex type that contains the following optional values:
\itemize{
\item For public and private hosted zones, an optional comment
\item For private hosted zones, an optional \code{PrivateZone} element
}

If you don't specify a comment or the \code{PrivateZone} element, omit
\code{HostedZoneConfig} and the other elements.}

\item{DelegationSetId}{If you want to associate a reusable delegation set with this hosted
zone, the ID that Amazon Route 53 assigned to the reusable delegation
set when you created it. For more information about reusable delegation
sets, see
\code{\link[=route53_create_reusable_delegation_set]{create_reusable_delegation_set}}.

If you are using a reusable delegation set to create a public hosted
zone for a subdomain, make sure that the parent hosted zone doesn't use
one or more of the same name servers. If you have overlapping
nameservers, the operation will cause a \code{ConflictingDomainsExist} error.}
}
\description{
Creates a new public or private hosted zone. You create records in a public hosted zone to define how you want to route traffic on the internet for a domain, such as example.com, and its subdomains (apex.example.com, acme.example.com). You create records in a private hosted zone to define how you want to route traffic for a domain and its subdomains within one or more Amazon Virtual Private Clouds (Amazon VPCs).

See \url{https://www.paws-r-sdk.com/docs/route53_create_hosted_zone/} for full documentation.
}
\keyword{internal}
