% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53domains_operations.R
\name{route53domains_transfer_domain}
\alias{route53domains_transfer_domain}
\title{Transfers a domain from another registrar to Amazon Route 53}
\usage{
route53domains_transfer_domain(
  DomainName,
  IdnLangCode = NULL,
  DurationInYears,
  Nameservers = NULL,
  AuthCode = NULL,
  AutoRenew = NULL,
  AdminContact,
  RegistrantContact,
  TechContact,
  PrivacyProtectAdminContact = NULL,
  PrivacyProtectRegistrantContact = NULL,
  PrivacyProtectTechContact = NULL
)
}
\arguments{
\item{DomainName}{[required] The name of the domain that you want to transfer to Route 53. The
top-level domain (TLD), such as .com, must be a TLD that Route 53
supports. For a list of supported TLDs, see \href{https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html}{Domains that You Can Register with Amazon Route 53}
in the \emph{Amazon Route 53 Developer Guide}.

The domain name can contain only the following characters:
\itemize{
\item Letters a through z. Domain names are not case sensitive.
\item Numbers 0 through 9.
\item Hyphen (-). You can't specify a hyphen at the beginning or end of a
label.
\item Period (.) to separate the labels in the name, such as the \code{.} in
\code{example.com}.
}}

\item{IdnLangCode}{Reserved for future use.}

\item{DurationInYears}{[required] The number of years that you want to register the domain for. Domains
are registered for a minimum of one year. The maximum period depends on
the top-level domain.

Default: 1}

\item{Nameservers}{Contains details for the host and glue IP addresses.}

\item{AuthCode}{The authorization code for the domain. You get this value from the
current registrar.}

\item{AutoRenew}{Indicates whether the domain will be automatically renewed (true) or not
(false). Auto renewal only takes effect after the account is charged.

Default: true}

\item{AdminContact}{[required] Provides detailed contact information.}

\item{RegistrantContact}{[required] Provides detailed contact information.}

\item{TechContact}{[required] Provides detailed contact information.}

\item{PrivacyProtectAdminContact}{Whether you want to conceal contact information from WHOIS queries. If
you specify \code{true}, WHOIS ("who is") queries return contact information
either for Amazon Registrar (for .com, .net, and .org domains) or for
our registrar associate, Gandi (for all other TLDs). If you specify
\code{false}, WHOIS queries return the information that you entered for the
admin contact.

You must specify the same privacy setting for the administrative,
registrant, and technical contacts.

Default: \code{true}}

\item{PrivacyProtectRegistrantContact}{Whether you want to conceal contact information from WHOIS queries. If
you specify \code{true}, WHOIS ("who is") queries return contact information
either for Amazon Registrar (for .com, .net, and .org domains) or for
our registrar associate, Gandi (for all other TLDs). If you specify
\code{false}, WHOIS queries return the information that you entered for the
registrant contact (domain owner).

You must specify the same privacy setting for the administrative,
registrant, and technical contacts.

Default: \code{true}}

\item{PrivacyProtectTechContact}{Whether you want to conceal contact information from WHOIS queries. If
you specify \code{true}, WHOIS ("who is") queries return contact information
either for Amazon Registrar (for .com, .net, and .org domains) or for
our registrar associate, Gandi (for all other TLDs). If you specify
\code{false}, WHOIS queries return the information that you entered for the
technical contact.

You must specify the same privacy setting for the administrative,
registrant, and technical contacts.

Default: \code{true}}
}
\description{
Transfers a domain from another registrar to Amazon Route 53. When the transfer is complete, the domain is registered either with Amazon Registrar (for .com, .net, and .org domains) or with our registrar associate, Gandi (for all other TLDs).

See \url{https://www.paws-r-sdk.com/docs/route53domains_transfer_domain/} for full documentation.
}
\keyword{internal}
