% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53recoverycontrolconfig_service.R
\name{route53recoverycontrolconfig}
\alias{route53recoverycontrolconfig}
\title{AWS Route53 Recovery Control Config}
\usage{
route53recoverycontrolconfig(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Recovery Control Configuration API Reference for Amazon Route 53
Application Recovery Controller
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- route53recoverycontrolconfig(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=route53recoverycontrolconfig_create_cluster]{create_cluster} \tab Create a new cluster\cr
\link[=route53recoverycontrolconfig_create_control_panel]{create_control_panel} \tab Creates a new control panel\cr
\link[=route53recoverycontrolconfig_create_routing_control]{create_routing_control} \tab Creates a new routing control\cr
\link[=route53recoverycontrolconfig_create_safety_rule]{create_safety_rule} \tab Creates a safety rule in a control panel\cr
\link[=route53recoverycontrolconfig_delete_cluster]{delete_cluster} \tab Delete a cluster\cr
\link[=route53recoverycontrolconfig_delete_control_panel]{delete_control_panel} \tab Deletes a control panel\cr
\link[=route53recoverycontrolconfig_delete_routing_control]{delete_routing_control} \tab Deletes a routing control\cr
\link[=route53recoverycontrolconfig_delete_safety_rule]{delete_safety_rule} \tab Deletes a safety rule\cr
\link[=route53recoverycontrolconfig_describe_cluster]{describe_cluster} \tab Display the details about a cluster\cr
\link[=route53recoverycontrolconfig_describe_control_panel]{describe_control_panel} \tab Displays details about a control panel\cr
\link[=route53recoverycontrolconfig_describe_routing_control]{describe_routing_control} \tab Displays details about a routing control\cr
\link[=route53recoverycontrolconfig_describe_safety_rule]{describe_safety_rule} \tab Returns information about a safety rule\cr
\link[=route53recoverycontrolconfig_list_associated_route_53_health_checks]{list_associated_route_53_health_checks} \tab Returns an array of all Amazon Route 53 health checks associated with a specific routing control\cr
\link[=route53recoverycontrolconfig_list_clusters]{list_clusters} \tab Returns an array of all the clusters in an account\cr
\link[=route53recoverycontrolconfig_list_control_panels]{list_control_panels} \tab Returns an array of control panels in an account or in a cluster\cr
\link[=route53recoverycontrolconfig_list_routing_controls]{list_routing_controls} \tab Returns an array of routing controls for a control panel\cr
\link[=route53recoverycontrolconfig_list_safety_rules]{list_safety_rules} \tab List the safety rules (the assertion rules and gating rules) that you've defined for the routing controls in a control panel\cr
\link[=route53recoverycontrolconfig_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags for a resource\cr
\link[=route53recoverycontrolconfig_tag_resource]{tag_resource} \tab Adds a tag to a resource\cr
\link[=route53recoverycontrolconfig_untag_resource]{untag_resource} \tab Removes a tag from a resource\cr
\link[=route53recoverycontrolconfig_update_control_panel]{update_control_panel} \tab Updates a control panel\cr
\link[=route53recoverycontrolconfig_update_routing_control]{update_routing_control} \tab Updates a routing control\cr
\link[=route53recoverycontrolconfig_update_safety_rule]{update_safety_rule} \tab Update a safety rule (an assertion rule or gating rule)
}
}

\examples{
\dontrun{
svc <- route53recoverycontrolconfig()
svc$create_cluster(
  Foo = 123
)
}

}
