% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_list_traffic_policy_instances_by_policy}
\alias{route53_list_traffic_policy_instances_by_policy}
\title{Gets information about the traffic policy instances that you created by
using a specify traffic policy version}
\usage{
route53_list_traffic_policy_instances_by_policy(
  TrafficPolicyId,
  TrafficPolicyVersion,
  HostedZoneIdMarker = NULL,
  TrafficPolicyInstanceNameMarker = NULL,
  TrafficPolicyInstanceTypeMarker = NULL,
  MaxItems = NULL
)
}
\arguments{
\item{TrafficPolicyId}{[required] The ID of the traffic policy for which you want to list traffic policy
instances.}

\item{TrafficPolicyVersion}{[required] The version of the traffic policy for which you want to list traffic
policy instances. The version must be associated with the traffic policy
that is specified by \code{TrafficPolicyId}.}

\item{HostedZoneIdMarker}{If the value of \code{IsTruncated} in the previous response was \code{true}, you
have more traffic policy instances. To get more traffic policy
instances, submit another
\code{\link[=route53_list_traffic_policy_instances_by_policy]{list_traffic_policy_instances_by_policy}}
request.

For the value of \code{hostedzoneid}, specify the value of
\code{HostedZoneIdMarker} from the previous response, which is the hosted
zone ID of the first traffic policy instance that Amazon Route 53 will
return if you submit another request.

If the value of \code{IsTruncated} in the previous response was \code{false},
there are no more traffic policy instances to get.}

\item{TrafficPolicyInstanceNameMarker}{If the value of \code{IsTruncated} in the previous response was \code{true}, you
have more traffic policy instances. To get more traffic policy
instances, submit another
\code{\link[=route53_list_traffic_policy_instances_by_policy]{list_traffic_policy_instances_by_policy}}
request.

For the value of \code{trafficpolicyinstancename}, specify the value of
\code{TrafficPolicyInstanceNameMarker} from the previous response, which is
the name of the first traffic policy instance that Amazon Route 53 will
return if you submit another request.

If the value of \code{IsTruncated} in the previous response was \code{false},
there are no more traffic policy instances to get.}

\item{TrafficPolicyInstanceTypeMarker}{If the value of \code{IsTruncated} in the previous response was \code{true}, you
have more traffic policy instances. To get more traffic policy
instances, submit another
\code{\link[=route53_list_traffic_policy_instances_by_policy]{list_traffic_policy_instances_by_policy}}
request.

For the value of \code{trafficpolicyinstancetype}, specify the value of
\code{TrafficPolicyInstanceTypeMarker} from the previous response, which is
the name of the first traffic policy instance that Amazon Route 53 will
return if you submit another request.

If the value of \code{IsTruncated} in the previous response was \code{false},
there are no more traffic policy instances to get.}

\item{MaxItems}{The maximum number of traffic policy instances to be included in the
response body for this request. If you have more than \code{MaxItems} traffic
policy instances, the value of the \code{IsTruncated} element in the response
is \code{true}, and the values of \code{HostedZoneIdMarker},
\code{TrafficPolicyInstanceNameMarker}, and \code{TrafficPolicyInstanceTypeMarker}
represent the first traffic policy instance that Amazon Route 53 will
return if you submit another request.}
}
\description{
Gets information about the traffic policy instances that you created by using a specify traffic policy version.

See \url{https://paws-r.github.io/docs/route53/list_traffic_policy_instances_by_policy.html} for full documentation.
}
\keyword{internal}
