% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_delete_gateway_route}
\alias{appmesh_delete_gateway_route}
\title{Deletes an existing gateway route}
\usage{
appmesh_delete_gateway_route(
  gatewayRouteName,
  meshName,
  meshOwner = NULL,
  virtualGatewayName
)
}
\arguments{
\item{gatewayRouteName}{[required] The name of the gateway route to delete.}

\item{meshName}{[required] The name of the service mesh to delete the gateway route from.}

\item{meshOwner}{The Amazon Web Services IAM account ID of the service mesh owner. If the
account ID is not your own, then it's the ID of the account that shared
the mesh with your account. For more information about mesh sharing, see
\href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{virtualGatewayName}{[required] The name of the virtual gateway to delete the route from.}
}
\description{
Deletes an existing gateway route.

See \url{https://paws-r.github.io/docs/appmesh/delete_gateway_route.html} for full documentation.
}
\keyword{internal}
