# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include route53_service.R
NULL

#' Activates a key-signing key (KSK) so that it can be used for signing by
#' DNSSEC
#'
#' @description
#' Activates a key-signing key (KSK) so that it can be used for signing by DNSSEC. This operation changes the KSK status to `ACTIVE`.
#'
#' See [https://paws-r.github.io/docs/route53/activate_key_signing_key.html](https://paws-r.github.io/docs/route53/activate_key_signing_key.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; A unique string used to identify a hosted zone.
#' @param Name &#91;required&#93; A string used to identify a key-signing key (KSK). `Name` can include
#' numbers, letters, and underscores (_). `Name` must be unique for each
#' key-signing key in the same hosted zone.
#'
#' @keywords internal
#'
#' @rdname route53_activate_key_signing_key
route53_activate_key_signing_key <- function(HostedZoneId, Name) {
  op <- new_operation(
    name = "ActivateKeySigningKey",
    http_method = "POST",
    http_path = "/2013-04-01/keysigningkey/{HostedZoneId}/{Name}/activate",
    paginator = list()
  )
  input <- .route53$activate_key_signing_key_input(HostedZoneId = HostedZoneId, Name = Name)
  output <- .route53$activate_key_signing_key_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$activate_key_signing_key <- route53_activate_key_signing_key

#' Associates an Amazon VPC with a private hosted zone
#'
#' @description
#' Associates an Amazon VPC with a private hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/associate_vpc_with_hosted_zone.html](https://paws-r.github.io/docs/route53/associate_vpc_with_hosted_zone.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; The ID of the private hosted zone that you want to associate an Amazon
#' VPC with.
#' 
#' Note that you can't associate a VPC with a hosted zone that doesn't have
#' an existing VPC association.
#' @param VPC &#91;required&#93; A complex type that contains information about the VPC that you want to
#' associate with a private hosted zone.
#' @param Comment *Optional:* A comment about the association request.
#'
#' @keywords internal
#'
#' @rdname route53_associate_vpc_with_hosted_zone
route53_associate_vpc_with_hosted_zone <- function(HostedZoneId, VPC, Comment = NULL) {
  op <- new_operation(
    name = "AssociateVPCWithHostedZone",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}/associatevpc",
    paginator = list()
  )
  input <- .route53$associate_vpc_with_hosted_zone_input(HostedZoneId = HostedZoneId, VPC = VPC, Comment = Comment)
  output <- .route53$associate_vpc_with_hosted_zone_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$associate_vpc_with_hosted_zone <- route53_associate_vpc_with_hosted_zone

#' Creates, changes, or deletes CIDR blocks within a collection
#'
#' @description
#' Creates, changes, or deletes CIDR blocks within a collection. Contains authoritative IP information mapping blocks to one or multiple locations.
#'
#' See [https://paws-r.github.io/docs/route53/change_cidr_collection.html](https://paws-r.github.io/docs/route53/change_cidr_collection.html) for full documentation.
#'
#' @param Id &#91;required&#93; The UUID of the CIDR collection to update.
#' @param CollectionVersion A sequential counter that Amazon Route 53 sets to 1 when you create a
#' collection and increments it by 1 each time you update the collection.
#' 
#' We recommend that you use `ListCidrCollection` to get the current value
#' of `CollectionVersion` for the collection that you want to update, and
#' then include that value with the change request. This prevents Route 53
#' from overwriting an intervening update:
#' 
#' -   If the value in the request matches the value of `CollectionVersion`
#'     in the collection, Route 53 updates the collection.
#' 
#' -   If the value of `CollectionVersion` in the collection is greater
#'     than the value in the request, the collection was changed after you
#'     got the version number. Route 53 does not update the collection, and
#'     it returns a `CidrCollectionVersionMismatch` error.
#' @param Changes &#91;required&#93; Information about changes to a CIDR collection.
#'
#' @keywords internal
#'
#' @rdname route53_change_cidr_collection
route53_change_cidr_collection <- function(Id, CollectionVersion = NULL, Changes) {
  op <- new_operation(
    name = "ChangeCidrCollection",
    http_method = "POST",
    http_path = "/2013-04-01/cidrcollection/{CidrCollectionId}",
    paginator = list()
  )
  input <- .route53$change_cidr_collection_input(Id = Id, CollectionVersion = CollectionVersion, Changes = Changes)
  output <- .route53$change_cidr_collection_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$change_cidr_collection <- route53_change_cidr_collection

#' Creates, changes, or deletes a resource record set, which contains
#' authoritative DNS information for a specified domain name or subdomain
#' name
#'
#' @description
#' Creates, changes, or deletes a resource record set, which contains authoritative DNS information for a specified domain name or subdomain name. For example, you can use [`change_resource_record_sets`][route53_change_resource_record_sets] to create a resource record set that routes traffic for test.example.com to a web server that has an IP address of 192.0.2.44.
#'
#' See [https://paws-r.github.io/docs/route53/change_resource_record_sets.html](https://paws-r.github.io/docs/route53/change_resource_record_sets.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone that contains the resource record sets that
#' you want to change.
#' @param ChangeBatch &#91;required&#93; A complex type that contains an optional comment and the `Changes`
#' element.
#'
#' @keywords internal
#'
#' @rdname route53_change_resource_record_sets
route53_change_resource_record_sets <- function(HostedZoneId, ChangeBatch) {
  op <- new_operation(
    name = "ChangeResourceRecordSets",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}/rrset/",
    paginator = list()
  )
  input <- .route53$change_resource_record_sets_input(HostedZoneId = HostedZoneId, ChangeBatch = ChangeBatch)
  output <- .route53$change_resource_record_sets_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$change_resource_record_sets <- route53_change_resource_record_sets

#' Adds, edits, or deletes tags for a health check or a hosted zone
#'
#' @description
#' Adds, edits, or deletes tags for a health check or a hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/change_tags_for_resource.html](https://paws-r.github.io/docs/route53/change_tags_for_resource.html) for full documentation.
#'
#' @param ResourceType &#91;required&#93; The type of the resource.
#' 
#' -   The resource type for health checks is `healthcheck`.
#' 
#' -   The resource type for hosted zones is `hostedzone`.
#' @param ResourceId &#91;required&#93; The ID of the resource for which you want to add, change, or delete
#' tags.
#' @param AddTags A complex type that contains a list of the tags that you want to add to
#' the specified health check or hosted zone and/or the tags that you want
#' to edit `Value` for.
#' 
#' You can add a maximum of 10 tags to a health check or a hosted zone.
#' @param RemoveTagKeys A complex type that contains a list of the tags that you want to delete
#' from the specified health check or hosted zone. You can specify up to 10
#' keys.
#'
#' @keywords internal
#'
#' @rdname route53_change_tags_for_resource
route53_change_tags_for_resource <- function(ResourceType, ResourceId, AddTags = NULL, RemoveTagKeys = NULL) {
  op <- new_operation(
    name = "ChangeTagsForResource",
    http_method = "POST",
    http_path = "/2013-04-01/tags/{ResourceType}/{ResourceId}",
    paginator = list()
  )
  input <- .route53$change_tags_for_resource_input(ResourceType = ResourceType, ResourceId = ResourceId, AddTags = AddTags, RemoveTagKeys = RemoveTagKeys)
  output <- .route53$change_tags_for_resource_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$change_tags_for_resource <- route53_change_tags_for_resource

#' Creates a CIDR collection in the current Amazon Web Services account
#'
#' @description
#' Creates a CIDR collection in the current Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/route53/create_cidr_collection.html](https://paws-r.github.io/docs/route53/create_cidr_collection.html) for full documentation.
#'
#' @param Name &#91;required&#93; A unique identifier for the account that can be used to reference the
#' collection from other API calls.
#' @param CallerReference &#91;required&#93; A client-specific token that allows requests to be securely retried so
#' that the intended outcome will only occur once, retries receive a
#' similar response, and there are no additional edge cases to handle.
#'
#' @keywords internal
#'
#' @rdname route53_create_cidr_collection
route53_create_cidr_collection <- function(Name, CallerReference) {
  op <- new_operation(
    name = "CreateCidrCollection",
    http_method = "POST",
    http_path = "/2013-04-01/cidrcollection",
    paginator = list()
  )
  input <- .route53$create_cidr_collection_input(Name = Name, CallerReference = CallerReference)
  output <- .route53$create_cidr_collection_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_cidr_collection <- route53_create_cidr_collection

#' Creates a new health check
#'
#' @description
#' Creates a new health check.
#'
#' See [https://paws-r.github.io/docs/route53/create_health_check.html](https://paws-r.github.io/docs/route53/create_health_check.html) for full documentation.
#'
#' @param CallerReference &#91;required&#93; A unique string that identifies the request and that allows you to retry
#' a failed [`create_health_check`][route53_create_health_check] request
#' without the risk of creating two identical health checks:
#' 
#' -   If you send a [`create_health_check`][route53_create_health_check]
#'     request with the same `CallerReference` and settings as a previous
#'     request, and if the health check doesn't exist, Amazon Route 53
#'     creates the health check. If the health check does exist, Route 53
#'     returns the settings for the existing health check.
#' 
#' -   If you send a [`create_health_check`][route53_create_health_check]
#'     request with the same `CallerReference` as a deleted health check,
#'     regardless of the settings, Route 53 returns a
#'     `HealthCheckAlreadyExists` error.
#' 
#' -   If you send a [`create_health_check`][route53_create_health_check]
#'     request with the same `CallerReference` as an existing health check
#'     but with different settings, Route 53 returns a
#'     `HealthCheckAlreadyExists` error.
#' 
#' -   If you send a [`create_health_check`][route53_create_health_check]
#'     request with a unique `CallerReference` but settings identical to an
#'     existing health check, Route 53 creates the health check.
#' @param HealthCheckConfig &#91;required&#93; A complex type that contains settings for a new health check.
#'
#' @keywords internal
#'
#' @rdname route53_create_health_check
route53_create_health_check <- function(CallerReference, HealthCheckConfig) {
  op <- new_operation(
    name = "CreateHealthCheck",
    http_method = "POST",
    http_path = "/2013-04-01/healthcheck",
    paginator = list()
  )
  input <- .route53$create_health_check_input(CallerReference = CallerReference, HealthCheckConfig = HealthCheckConfig)
  output <- .route53$create_health_check_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_health_check <- route53_create_health_check

#' Creates a new public or private hosted zone
#'
#' @description
#' Creates a new public or private hosted zone. You create records in a public hosted zone to define how you want to route traffic on the internet for a domain, such as example.com, and its subdomains (apex.example.com, acme.example.com). You create records in a private hosted zone to define how you want to route traffic for a domain and its subdomains within one or more Amazon Virtual Private Clouds (Amazon VPCs).
#'
#' See [https://paws-r.github.io/docs/route53/create_hosted_zone.html](https://paws-r.github.io/docs/route53/create_hosted_zone.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the domain. Specify a fully qualified domain name, for
#' example, *www.example.com*. The trailing dot is optional; Amazon
#' Route 53 assumes that the domain name is fully qualified. This means
#' that Route 53 treats *www.example.com* (without a trailing dot) and
#' *www.example.com.* (with a trailing dot) as identical.
#' 
#' If you're creating a public hosted zone, this is the name you have
#' registered with your DNS registrar. If your domain name is registered
#' with a registrar other than Route 53, change the name servers for your
#' domain to the set of `NameServers` that
#' [`create_hosted_zone`][route53_create_hosted_zone] returns in
#' `DelegationSet`.
#' @param VPC (Private hosted zones only) A complex type that contains information
#' about the Amazon VPC that you're associating with this hosted zone.
#' 
#' You can specify only one Amazon VPC when you create a private hosted
#' zone. If you are associating a VPC with a hosted zone with this request,
#' the paramaters `VPCId` and `VPCRegion` are also required.
#' 
#' To associate additional Amazon VPCs with the hosted zone, use
#' [`associate_vpc_with_hosted_zone`][route53_associate_vpc_with_hosted_zone]
#' after you create a hosted zone.
#' @param CallerReference &#91;required&#93; A unique string that identifies the request and that allows failed
#' [`create_hosted_zone`][route53_create_hosted_zone] requests to be
#' retried without the risk of executing the operation twice. You must use
#' a unique `CallerReference` string every time you submit a
#' [`create_hosted_zone`][route53_create_hosted_zone] request.
#' `CallerReference` can be any unique string, for example, a date/time
#' stamp.
#' @param HostedZoneConfig (Optional) A complex type that contains the following optional values:
#' 
#' -   For public and private hosted zones, an optional comment
#' 
#' -   For private hosted zones, an optional `PrivateZone` element
#' 
#' If you don't specify a comment or the `PrivateZone` element, omit
#' `HostedZoneConfig` and the other elements.
#' @param DelegationSetId If you want to associate a reusable delegation set with this hosted
#' zone, the ID that Amazon Route 53 assigned to the reusable delegation
#' set when you created it. For more information about reusable delegation
#' sets, see
#' [`create_reusable_delegation_set`][route53_create_reusable_delegation_set].
#'
#' @keywords internal
#'
#' @rdname route53_create_hosted_zone
route53_create_hosted_zone <- function(Name, VPC = NULL, CallerReference, HostedZoneConfig = NULL, DelegationSetId = NULL) {
  op <- new_operation(
    name = "CreateHostedZone",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone",
    paginator = list()
  )
  input <- .route53$create_hosted_zone_input(Name = Name, VPC = VPC, CallerReference = CallerReference, HostedZoneConfig = HostedZoneConfig, DelegationSetId = DelegationSetId)
  output <- .route53$create_hosted_zone_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_hosted_zone <- route53_create_hosted_zone

#' Creates a new key-signing key (KSK) associated with a hosted zone
#'
#' @description
#' Creates a new key-signing key (KSK) associated with a hosted zone. You can only have two KSKs per hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/create_key_signing_key.html](https://paws-r.github.io/docs/route53/create_key_signing_key.html) for full documentation.
#'
#' @param CallerReference &#91;required&#93; A unique string that identifies the request.
#' @param HostedZoneId &#91;required&#93; The unique string (ID) used to identify a hosted zone.
#' @param KeyManagementServiceArn &#91;required&#93; The Amazon resource name (ARN) for a customer managed key in Key
#' Management Service (KMS). The `KeyManagementServiceArn` must be unique
#' for each key-signing key (KSK) in a single hosted zone. To see an
#' example of `KeyManagementServiceArn` that grants the correct permissions
#' for DNSSEC, scroll down to **Example**.
#' 
#' You must configure the customer managed customer managed key as follows:
#' 
#' **Status**
#' 
#' Enabled
#' 
#' **Key spec**
#' 
#' ECC_NIST_P256
#' 
#' **Key usage**
#' 
#' Sign and verify
#' 
#' **Key policy**
#' 
#' The key policy must give permission for the following actions:
#' 
#' -   DescribeKey
#' 
#' -   GetPublicKey
#' 
#' -   Sign
#' 
#' The key policy must also include the Amazon Route 53 service in the
#' principal for your account. Specify the following:
#' 
#' -   `"Service": "dnssec-route53.amazonaws.com"`
#' 
#' For more information about working with a customer managed key in KMS,
#' see [Key Management Service
#' concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html).
#' @param Name &#91;required&#93; A string used to identify a key-signing key (KSK). `Name` can include
#' numbers, letters, and underscores (_). `Name` must be unique for each
#' key-signing key in the same hosted zone.
#' @param Status &#91;required&#93; A string specifying the initial status of the key-signing key (KSK). You
#' can set the value to `ACTIVE` or `INACTIVE`.
#'
#' @keywords internal
#'
#' @rdname route53_create_key_signing_key
route53_create_key_signing_key <- function(CallerReference, HostedZoneId, KeyManagementServiceArn, Name, Status) {
  op <- new_operation(
    name = "CreateKeySigningKey",
    http_method = "POST",
    http_path = "/2013-04-01/keysigningkey",
    paginator = list()
  )
  input <- .route53$create_key_signing_key_input(CallerReference = CallerReference, HostedZoneId = HostedZoneId, KeyManagementServiceArn = KeyManagementServiceArn, Name = Name, Status = Status)
  output <- .route53$create_key_signing_key_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_key_signing_key <- route53_create_key_signing_key

#' Creates a configuration for DNS query logging
#'
#' @description
#' Creates a configuration for DNS query logging. After you create a query logging configuration, Amazon Route 53 begins to publish log data to an Amazon CloudWatch Logs log group.
#'
#' See [https://paws-r.github.io/docs/route53/create_query_logging_config.html](https://paws-r.github.io/docs/route53/create_query_logging_config.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone that you want to log queries for. You can log
#' queries only for public hosted zones.
#' @param CloudWatchLogsLogGroupArn &#91;required&#93; The Amazon Resource Name (ARN) for the log group that you want to Amazon
#' Route 53 to send query logs to. This is the format of the ARN:
#' 
#' arn:aws:logs:*region*:*account-id*:log-group:*log_group_name*
#' 
#' To get the ARN for a log group, you can use the CloudWatch console, the
#' [DescribeLogGroups](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html)
#' API action, the
#' [describe-log-groups](https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html)
#' command, or the applicable command in one of the Amazon Web Services
#' SDKs.
#'
#' @keywords internal
#'
#' @rdname route53_create_query_logging_config
route53_create_query_logging_config <- function(HostedZoneId, CloudWatchLogsLogGroupArn) {
  op <- new_operation(
    name = "CreateQueryLoggingConfig",
    http_method = "POST",
    http_path = "/2013-04-01/queryloggingconfig",
    paginator = list()
  )
  input <- .route53$create_query_logging_config_input(HostedZoneId = HostedZoneId, CloudWatchLogsLogGroupArn = CloudWatchLogsLogGroupArn)
  output <- .route53$create_query_logging_config_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_query_logging_config <- route53_create_query_logging_config

#' Creates a delegation set (a group of four name servers) that can be
#' reused by multiple hosted zones that were created by the same Amazon Web
#' Services account
#'
#' @description
#' Creates a delegation set (a group of four name servers) that can be reused by multiple hosted zones that were created by the same Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/route53/create_reusable_delegation_set.html](https://paws-r.github.io/docs/route53/create_reusable_delegation_set.html) for full documentation.
#'
#' @param CallerReference &#91;required&#93; A unique string that identifies the request, and that allows you to
#' retry failed
#' [`create_reusable_delegation_set`][route53_create_reusable_delegation_set]
#' requests without the risk of executing the operation twice. You must use
#' a unique `CallerReference` string every time you submit a
#' [`create_reusable_delegation_set`][route53_create_reusable_delegation_set]
#' request. `CallerReference` can be any unique string, for example a
#' date/time stamp.
#' @param HostedZoneId If you want to mark the delegation set for an existing hosted zone as
#' reusable, the ID for that hosted zone.
#'
#' @keywords internal
#'
#' @rdname route53_create_reusable_delegation_set
route53_create_reusable_delegation_set <- function(CallerReference, HostedZoneId = NULL) {
  op <- new_operation(
    name = "CreateReusableDelegationSet",
    http_method = "POST",
    http_path = "/2013-04-01/delegationset",
    paginator = list()
  )
  input <- .route53$create_reusable_delegation_set_input(CallerReference = CallerReference, HostedZoneId = HostedZoneId)
  output <- .route53$create_reusable_delegation_set_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_reusable_delegation_set <- route53_create_reusable_delegation_set

#' Creates a traffic policy, which you use to create multiple DNS resource
#' record sets for one domain name (such as example
#'
#' @description
#' Creates a traffic policy, which you use to create multiple DNS resource record sets for one domain name (such as example.com) or one subdomain name (such as www.example.com).
#'
#' See [https://paws-r.github.io/docs/route53/create_traffic_policy.html](https://paws-r.github.io/docs/route53/create_traffic_policy.html) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the traffic policy.
#' @param Document &#91;required&#93; The definition of this traffic policy in JSON format. For more
#' information, see [Traffic Policy Document
#' Format](https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html).
#' @param Comment (Optional) Any comments that you want to include about the traffic
#' policy.
#'
#' @keywords internal
#'
#' @rdname route53_create_traffic_policy
route53_create_traffic_policy <- function(Name, Document, Comment = NULL) {
  op <- new_operation(
    name = "CreateTrafficPolicy",
    http_method = "POST",
    http_path = "/2013-04-01/trafficpolicy",
    paginator = list()
  )
  input <- .route53$create_traffic_policy_input(Name = Name, Document = Document, Comment = Comment)
  output <- .route53$create_traffic_policy_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_traffic_policy <- route53_create_traffic_policy

#' Creates resource record sets in a specified hosted zone based on the
#' settings in a specified traffic policy version
#'
#' @description
#' Creates resource record sets in a specified hosted zone based on the settings in a specified traffic policy version. In addition, [`create_traffic_policy_instance`][route53_create_traffic_policy_instance] associates the resource record sets with a specified domain name (such as example.com) or subdomain name (such as www.example.com). Amazon Route 53 responds to DNS queries for the domain or subdomain name by using the resource record sets that [`create_traffic_policy_instance`][route53_create_traffic_policy_instance] created.
#'
#' See [https://paws-r.github.io/docs/route53/create_traffic_policy_instance.html](https://paws-r.github.io/docs/route53/create_traffic_policy_instance.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone that you want Amazon Route 53 to create
#' resource record sets in by using the configuration in a traffic policy.
#' @param Name &#91;required&#93; The domain name (such as example.com) or subdomain name (such as
#' www.example.com) for which Amazon Route 53 responds to DNS queries by
#' using the resource record sets that Route 53 creates for this traffic
#' policy instance.
#' @param TTL &#91;required&#93; (Optional) The TTL that you want Amazon Route 53 to assign to all of the
#' resource record sets that it creates in the specified hosted zone.
#' @param TrafficPolicyId &#91;required&#93; The ID of the traffic policy that you want to use to create resource
#' record sets in the specified hosted zone.
#' @param TrafficPolicyVersion &#91;required&#93; The version of the traffic policy that you want to use to create
#' resource record sets in the specified hosted zone.
#'
#' @keywords internal
#'
#' @rdname route53_create_traffic_policy_instance
route53_create_traffic_policy_instance <- function(HostedZoneId, Name, TTL, TrafficPolicyId, TrafficPolicyVersion) {
  op <- new_operation(
    name = "CreateTrafficPolicyInstance",
    http_method = "POST",
    http_path = "/2013-04-01/trafficpolicyinstance",
    paginator = list()
  )
  input <- .route53$create_traffic_policy_instance_input(HostedZoneId = HostedZoneId, Name = Name, TTL = TTL, TrafficPolicyId = TrafficPolicyId, TrafficPolicyVersion = TrafficPolicyVersion)
  output <- .route53$create_traffic_policy_instance_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_traffic_policy_instance <- route53_create_traffic_policy_instance

#' Creates a new version of an existing traffic policy
#'
#' @description
#' Creates a new version of an existing traffic policy. When you create a new version of a traffic policy, you specify the ID of the traffic policy that you want to update and a JSON-formatted document that describes the new version. You use traffic policies to create multiple DNS resource record sets for one domain name (such as example.com) or one subdomain name (such as www.example.com). You can create a maximum of 1000 versions of a traffic policy. If you reach the limit and need to create another version, you'll need to start a new traffic policy.
#'
#' See [https://paws-r.github.io/docs/route53/create_traffic_policy_version.html](https://paws-r.github.io/docs/route53/create_traffic_policy_version.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the traffic policy for which you want to create a new version.
#' @param Document &#91;required&#93; The definition of this version of the traffic policy, in JSON format.
#' You specified the JSON in the
#' [`create_traffic_policy_version`][route53_create_traffic_policy_version]
#' request. For more information about the JSON format, see
#' [`create_traffic_policy`][route53_create_traffic_policy].
#' @param Comment The comment that you specified in the
#' [`create_traffic_policy_version`][route53_create_traffic_policy_version]
#' request, if any.
#'
#' @keywords internal
#'
#' @rdname route53_create_traffic_policy_version
route53_create_traffic_policy_version <- function(Id, Document, Comment = NULL) {
  op <- new_operation(
    name = "CreateTrafficPolicyVersion",
    http_method = "POST",
    http_path = "/2013-04-01/trafficpolicy/{Id}",
    paginator = list()
  )
  input <- .route53$create_traffic_policy_version_input(Id = Id, Document = Document, Comment = Comment)
  output <- .route53$create_traffic_policy_version_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_traffic_policy_version <- route53_create_traffic_policy_version

#' Authorizes the Amazon Web Services account that created a specified VPC
#' to submit an AssociateVPCWithHostedZone request to associate the VPC
#' with a specified hosted zone that was created by a different account
#'
#' @description
#' Authorizes the Amazon Web Services account that created a specified VPC to submit an [`associate_vpc_with_hosted_zone`][route53_associate_vpc_with_hosted_zone] request to associate the VPC with a specified hosted zone that was created by a different account. To submit a [`create_vpc_association_authorization`][route53_create_vpc_association_authorization] request, you must use the account that created the hosted zone. After you authorize the association, use the account that created the VPC to submit an [`associate_vpc_with_hosted_zone`][route53_associate_vpc_with_hosted_zone] request.
#'
#' See [https://paws-r.github.io/docs/route53/create_vpc_association_authorization.html](https://paws-r.github.io/docs/route53/create_vpc_association_authorization.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; The ID of the private hosted zone that you want to authorize associating
#' a VPC with.
#' @param VPC &#91;required&#93; A complex type that contains the VPC ID and region for the VPC that you
#' want to authorize associating with your hosted zone.
#'
#' @keywords internal
#'
#' @rdname route53_create_vpc_association_authorization
route53_create_vpc_association_authorization <- function(HostedZoneId, VPC) {
  op <- new_operation(
    name = "CreateVPCAssociationAuthorization",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}/authorizevpcassociation",
    paginator = list()
  )
  input <- .route53$create_vpc_association_authorization_input(HostedZoneId = HostedZoneId, VPC = VPC)
  output <- .route53$create_vpc_association_authorization_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_vpc_association_authorization <- route53_create_vpc_association_authorization

#' Deactivates a key-signing key (KSK) so that it will not be used for
#' signing by DNSSEC
#'
#' @description
#' Deactivates a key-signing key (KSK) so that it will not be used for signing by DNSSEC. This operation changes the KSK status to `INACTIVE`.
#'
#' See [https://paws-r.github.io/docs/route53/deactivate_key_signing_key.html](https://paws-r.github.io/docs/route53/deactivate_key_signing_key.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; A unique string used to identify a hosted zone.
#' @param Name &#91;required&#93; A string used to identify a key-signing key (KSK).
#'
#' @keywords internal
#'
#' @rdname route53_deactivate_key_signing_key
route53_deactivate_key_signing_key <- function(HostedZoneId, Name) {
  op <- new_operation(
    name = "DeactivateKeySigningKey",
    http_method = "POST",
    http_path = "/2013-04-01/keysigningkey/{HostedZoneId}/{Name}/deactivate",
    paginator = list()
  )
  input <- .route53$deactivate_key_signing_key_input(HostedZoneId = HostedZoneId, Name = Name)
  output <- .route53$deactivate_key_signing_key_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$deactivate_key_signing_key <- route53_deactivate_key_signing_key

#' Deletes a CIDR collection in the current Amazon Web Services account
#'
#' @description
#' Deletes a CIDR collection in the current Amazon Web Services account. The collection must be empty before it can be deleted.
#'
#' See [https://paws-r.github.io/docs/route53/delete_cidr_collection.html](https://paws-r.github.io/docs/route53/delete_cidr_collection.html) for full documentation.
#'
#' @param Id &#91;required&#93; The UUID of the collection to delete.
#'
#' @keywords internal
#'
#' @rdname route53_delete_cidr_collection
route53_delete_cidr_collection <- function(Id) {
  op <- new_operation(
    name = "DeleteCidrCollection",
    http_method = "DELETE",
    http_path = "/2013-04-01/cidrcollection/{CidrCollectionId}",
    paginator = list()
  )
  input <- .route53$delete_cidr_collection_input(Id = Id)
  output <- .route53$delete_cidr_collection_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_cidr_collection <- route53_delete_cidr_collection

#' Deletes a health check
#'
#' @description
#' Deletes a health check.
#'
#' See [https://paws-r.github.io/docs/route53/delete_health_check.html](https://paws-r.github.io/docs/route53/delete_health_check.html) for full documentation.
#'
#' @param HealthCheckId &#91;required&#93; The ID of the health check that you want to delete.
#'
#' @keywords internal
#'
#' @rdname route53_delete_health_check
route53_delete_health_check <- function(HealthCheckId) {
  op <- new_operation(
    name = "DeleteHealthCheck",
    http_method = "DELETE",
    http_path = "/2013-04-01/healthcheck/{HealthCheckId}",
    paginator = list()
  )
  input <- .route53$delete_health_check_input(HealthCheckId = HealthCheckId)
  output <- .route53$delete_health_check_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_health_check <- route53_delete_health_check

#' Deletes a hosted zone
#'
#' @description
#' Deletes a hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/delete_hosted_zone.html](https://paws-r.github.io/docs/route53/delete_hosted_zone.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the hosted zone you want to delete.
#'
#' @keywords internal
#'
#' @rdname route53_delete_hosted_zone
route53_delete_hosted_zone <- function(Id) {
  op <- new_operation(
    name = "DeleteHostedZone",
    http_method = "DELETE",
    http_path = "/2013-04-01/hostedzone/{Id}",
    paginator = list()
  )
  input <- .route53$delete_hosted_zone_input(Id = Id)
  output <- .route53$delete_hosted_zone_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_hosted_zone <- route53_delete_hosted_zone

#' Deletes a key-signing key (KSK)
#'
#' @description
#' Deletes a key-signing key (KSK). Before you can delete a KSK, you must deactivate it. The KSK must be deactivated before you can delete it regardless of whether the hosted zone is enabled for DNSSEC signing.
#'
#' See [https://paws-r.github.io/docs/route53/delete_key_signing_key.html](https://paws-r.github.io/docs/route53/delete_key_signing_key.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; A unique string used to identify a hosted zone.
#' @param Name &#91;required&#93; A string used to identify a key-signing key (KSK).
#'
#' @keywords internal
#'
#' @rdname route53_delete_key_signing_key
route53_delete_key_signing_key <- function(HostedZoneId, Name) {
  op <- new_operation(
    name = "DeleteKeySigningKey",
    http_method = "DELETE",
    http_path = "/2013-04-01/keysigningkey/{HostedZoneId}/{Name}",
    paginator = list()
  )
  input <- .route53$delete_key_signing_key_input(HostedZoneId = HostedZoneId, Name = Name)
  output <- .route53$delete_key_signing_key_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_key_signing_key <- route53_delete_key_signing_key

#' Deletes a configuration for DNS query logging
#'
#' @description
#' Deletes a configuration for DNS query logging. If you delete a configuration, Amazon Route 53 stops sending query logs to CloudWatch Logs. Route 53 doesn't delete any logs that are already in CloudWatch Logs.
#'
#' See [https://paws-r.github.io/docs/route53/delete_query_logging_config.html](https://paws-r.github.io/docs/route53/delete_query_logging_config.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the configuration that you want to delete.
#'
#' @keywords internal
#'
#' @rdname route53_delete_query_logging_config
route53_delete_query_logging_config <- function(Id) {
  op <- new_operation(
    name = "DeleteQueryLoggingConfig",
    http_method = "DELETE",
    http_path = "/2013-04-01/queryloggingconfig/{Id}",
    paginator = list()
  )
  input <- .route53$delete_query_logging_config_input(Id = Id)
  output <- .route53$delete_query_logging_config_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_query_logging_config <- route53_delete_query_logging_config

#' Deletes a reusable delegation set
#'
#' @description
#' Deletes a reusable delegation set.
#'
#' See [https://paws-r.github.io/docs/route53/delete_reusable_delegation_set.html](https://paws-r.github.io/docs/route53/delete_reusable_delegation_set.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the reusable delegation set that you want to delete.
#'
#' @keywords internal
#'
#' @rdname route53_delete_reusable_delegation_set
route53_delete_reusable_delegation_set <- function(Id) {
  op <- new_operation(
    name = "DeleteReusableDelegationSet",
    http_method = "DELETE",
    http_path = "/2013-04-01/delegationset/{Id}",
    paginator = list()
  )
  input <- .route53$delete_reusable_delegation_set_input(Id = Id)
  output <- .route53$delete_reusable_delegation_set_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_reusable_delegation_set <- route53_delete_reusable_delegation_set

#' Deletes a traffic policy
#'
#' @description
#' Deletes a traffic policy.
#'
#' See [https://paws-r.github.io/docs/route53/delete_traffic_policy.html](https://paws-r.github.io/docs/route53/delete_traffic_policy.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the traffic policy that you want to delete.
#' @param Version &#91;required&#93; The version number of the traffic policy that you want to delete.
#'
#' @keywords internal
#'
#' @rdname route53_delete_traffic_policy
route53_delete_traffic_policy <- function(Id, Version) {
  op <- new_operation(
    name = "DeleteTrafficPolicy",
    http_method = "DELETE",
    http_path = "/2013-04-01/trafficpolicy/{Id}/{Version}",
    paginator = list()
  )
  input <- .route53$delete_traffic_policy_input(Id = Id, Version = Version)
  output <- .route53$delete_traffic_policy_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_traffic_policy <- route53_delete_traffic_policy

#' Deletes a traffic policy instance and all of the resource record sets
#' that Amazon Route 53 created when you created the instance
#'
#' @description
#' Deletes a traffic policy instance and all of the resource record sets that Amazon Route 53 created when you created the instance.
#'
#' See [https://paws-r.github.io/docs/route53/delete_traffic_policy_instance.html](https://paws-r.github.io/docs/route53/delete_traffic_policy_instance.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the traffic policy instance that you want to delete.
#' 
#' When you delete a traffic policy instance, Amazon Route 53 also deletes
#' all of the resource record sets that were created when you created the
#' traffic policy instance.
#'
#' @keywords internal
#'
#' @rdname route53_delete_traffic_policy_instance
route53_delete_traffic_policy_instance <- function(Id) {
  op <- new_operation(
    name = "DeleteTrafficPolicyInstance",
    http_method = "DELETE",
    http_path = "/2013-04-01/trafficpolicyinstance/{Id}",
    paginator = list()
  )
  input <- .route53$delete_traffic_policy_instance_input(Id = Id)
  output <- .route53$delete_traffic_policy_instance_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_traffic_policy_instance <- route53_delete_traffic_policy_instance

#' Removes authorization to submit an AssociateVPCWithHostedZone request to
#' associate a specified VPC with a hosted zone that was created by a
#' different account
#'
#' @description
#' Removes authorization to submit an [`associate_vpc_with_hosted_zone`][route53_associate_vpc_with_hosted_zone] request to associate a specified VPC with a hosted zone that was created by a different account. You must use the account that created the hosted zone to submit a [`delete_vpc_association_authorization`][route53_delete_vpc_association_authorization] request.
#'
#' See [https://paws-r.github.io/docs/route53/delete_vpc_association_authorization.html](https://paws-r.github.io/docs/route53/delete_vpc_association_authorization.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; When removing authorization to associate a VPC that was created by one
#' Amazon Web Services account with a hosted zone that was created with a
#' different Amazon Web Services account, the ID of the hosted zone.
#' @param VPC &#91;required&#93; When removing authorization to associate a VPC that was created by one
#' Amazon Web Services account with a hosted zone that was created with a
#' different Amazon Web Services account, a complex type that includes the
#' ID and region of the VPC.
#'
#' @keywords internal
#'
#' @rdname route53_delete_vpc_association_authorization
route53_delete_vpc_association_authorization <- function(HostedZoneId, VPC) {
  op <- new_operation(
    name = "DeleteVPCAssociationAuthorization",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}/deauthorizevpcassociation",
    paginator = list()
  )
  input <- .route53$delete_vpc_association_authorization_input(HostedZoneId = HostedZoneId, VPC = VPC)
  output <- .route53$delete_vpc_association_authorization_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_vpc_association_authorization <- route53_delete_vpc_association_authorization

#' Disables DNSSEC signing in a specific hosted zone
#'
#' @description
#' Disables DNSSEC signing in a specific hosted zone. This action does not deactivate any key-signing keys (KSKs) that are active in the hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/disable_hosted_zone_dnssec.html](https://paws-r.github.io/docs/route53/disable_hosted_zone_dnssec.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; A unique string used to identify a hosted zone.
#'
#' @keywords internal
#'
#' @rdname route53_disable_hosted_zone_dnssec
route53_disable_hosted_zone_dnssec <- function(HostedZoneId) {
  op <- new_operation(
    name = "DisableHostedZoneDNSSEC",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}/disable-dnssec",
    paginator = list()
  )
  input <- .route53$disable_hosted_zone_dnssec_input(HostedZoneId = HostedZoneId)
  output <- .route53$disable_hosted_zone_dnssec_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$disable_hosted_zone_dnssec <- route53_disable_hosted_zone_dnssec

#' Disassociates an Amazon Virtual Private Cloud (Amazon VPC) from an
#' Amazon Route 53 private hosted zone
#'
#' @description
#' Disassociates an Amazon Virtual Private Cloud (Amazon VPC) from an Amazon Route 53 private hosted zone. Note the following:
#'
#' See [https://paws-r.github.io/docs/route53/disassociate_vpc_from_hosted_zone.html](https://paws-r.github.io/docs/route53/disassociate_vpc_from_hosted_zone.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; The ID of the private hosted zone that you want to disassociate a VPC
#' from.
#' @param VPC &#91;required&#93; A complex type that contains information about the VPC that you're
#' disassociating from the specified hosted zone.
#' @param Comment *Optional:* A comment about the disassociation request.
#'
#' @keywords internal
#'
#' @rdname route53_disassociate_vpc_from_hosted_zone
route53_disassociate_vpc_from_hosted_zone <- function(HostedZoneId, VPC, Comment = NULL) {
  op <- new_operation(
    name = "DisassociateVPCFromHostedZone",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}/disassociatevpc",
    paginator = list()
  )
  input <- .route53$disassociate_vpc_from_hosted_zone_input(HostedZoneId = HostedZoneId, VPC = VPC, Comment = Comment)
  output <- .route53$disassociate_vpc_from_hosted_zone_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$disassociate_vpc_from_hosted_zone <- route53_disassociate_vpc_from_hosted_zone

#' Enables DNSSEC signing in a specific hosted zone
#'
#' @description
#' Enables DNSSEC signing in a specific hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/enable_hosted_zone_dnssec.html](https://paws-r.github.io/docs/route53/enable_hosted_zone_dnssec.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; A unique string used to identify a hosted zone.
#'
#' @keywords internal
#'
#' @rdname route53_enable_hosted_zone_dnssec
route53_enable_hosted_zone_dnssec <- function(HostedZoneId) {
  op <- new_operation(
    name = "EnableHostedZoneDNSSEC",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}/enable-dnssec",
    paginator = list()
  )
  input <- .route53$enable_hosted_zone_dnssec_input(HostedZoneId = HostedZoneId)
  output <- .route53$enable_hosted_zone_dnssec_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$enable_hosted_zone_dnssec <- route53_enable_hosted_zone_dnssec

#' Gets the specified limit for the current account, for example, the
#' maximum number of health checks that you can create using the account
#'
#' @description
#' Gets the specified limit for the current account, for example, the maximum number of health checks that you can create using the account.
#'
#' See [https://paws-r.github.io/docs/route53/get_account_limit.html](https://paws-r.github.io/docs/route53/get_account_limit.html) for full documentation.
#'
#' @param Type &#91;required&#93; The limit that you want to get. Valid values include the following:
#' 
#' -   **MAX_HEALTH_CHECKS_BY_OWNER**: The maximum number of health checks
#'     that you can create using the current account.
#' 
#' -   **MAX_HOSTED_ZONES_BY_OWNER**: The maximum number of hosted zones
#'     that you can create using the current account.
#' 
#' -   **MAX_REUSABLE_DELEGATION_SETS_BY_OWNER**: The maximum number of
#'     reusable delegation sets that you can create using the current
#'     account.
#' 
#' -   **MAX_TRAFFIC_POLICIES_BY_OWNER**: The maximum number of traffic
#'     policies that you can create using the current account.
#' 
#' -   **MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER**: The maximum number of
#'     traffic policy instances that you can create using the current
#'     account. (Traffic policy instances are referred to as traffic flow
#'     policy records in the Amazon Route 53 console.)
#'
#' @keywords internal
#'
#' @rdname route53_get_account_limit
route53_get_account_limit <- function(Type) {
  op <- new_operation(
    name = "GetAccountLimit",
    http_method = "GET",
    http_path = "/2013-04-01/accountlimit/{Type}",
    paginator = list()
  )
  input <- .route53$get_account_limit_input(Type = Type)
  output <- .route53$get_account_limit_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_account_limit <- route53_get_account_limit

#' Returns the current status of a change batch request
#'
#' @description
#' Returns the current status of a change batch request. The status is one of the following values:
#'
#' See [https://paws-r.github.io/docs/route53/get_change.html](https://paws-r.github.io/docs/route53/get_change.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the change batch request. The value that you specify here is
#' the value that
#' [`change_resource_record_sets`][route53_change_resource_record_sets]
#' returned in the `Id` element when you submitted the request.
#'
#' @keywords internal
#'
#' @rdname route53_get_change
route53_get_change <- function(Id) {
  op <- new_operation(
    name = "GetChange",
    http_method = "GET",
    http_path = "/2013-04-01/change/{Id}",
    paginator = list()
  )
  input <- .route53$get_change_input(Id = Id)
  output <- .route53$get_change_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_change <- route53_get_change

#' Route 53 does not perform authorization for this API because it
#' retrieves information that is already available to the public
#'
#' @description
#' Route 53 does not perform authorization for this API because it retrieves information that is already available to the public.
#'
#' See [https://paws-r.github.io/docs/route53/get_checker_ip_ranges.html](https://paws-r.github.io/docs/route53/get_checker_ip_ranges.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname route53_get_checker_ip_ranges
route53_get_checker_ip_ranges <- function() {
  op <- new_operation(
    name = "GetCheckerIpRanges",
    http_method = "GET",
    http_path = "/2013-04-01/checkeripranges",
    paginator = list()
  )
  input <- .route53$get_checker_ip_ranges_input()
  output <- .route53$get_checker_ip_ranges_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_checker_ip_ranges <- route53_get_checker_ip_ranges

#' Returns information about DNSSEC for a specific hosted zone, including
#' the key-signing keys (KSKs) in the hosted zone
#'
#' @description
#' Returns information about DNSSEC for a specific hosted zone, including the key-signing keys (KSKs) in the hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/get_dnssec.html](https://paws-r.github.io/docs/route53/get_dnssec.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; A unique string used to identify a hosted zone.
#'
#' @keywords internal
#'
#' @rdname route53_get_dnssec
route53_get_dnssec <- function(HostedZoneId) {
  op <- new_operation(
    name = "GetDNSSEC",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzone/{Id}/dnssec",
    paginator = list()
  )
  input <- .route53$get_dnssec_input(HostedZoneId = HostedZoneId)
  output <- .route53$get_dnssec_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_dnssec <- route53_get_dnssec

#' Gets information about whether a specified geographic location is
#' supported for Amazon Route 53 geolocation resource record sets
#'
#' @description
#' Gets information about whether a specified geographic location is supported for Amazon Route 53 geolocation resource record sets.
#'
#' See [https://paws-r.github.io/docs/route53/get_geo_location.html](https://paws-r.github.io/docs/route53/get_geo_location.html) for full documentation.
#'
#' @param ContinentCode For geolocation resource record sets, a two-letter abbreviation that
#' identifies a continent. Amazon Route 53 supports the following continent
#' codes:
#' 
#' -   **AF**: Africa
#' 
#' -   **AN**: Antarctica
#' 
#' -   **AS**: Asia
#' 
#' -   **EU**: Europe
#' 
#' -   **OC**: Oceania
#' 
#' -   **NA**: North America
#' 
#' -   **SA**: South America
#' @param CountryCode Amazon Route 53 uses the two-letter country codes that are specified in
#' [ISO standard 3166-1
#' alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
#' @param SubdivisionCode The code for the subdivision, such as a particular state within the
#' United States. For a list of US state abbreviations, see Appendix B:
#' Two–Letter State and Possession Abbreviations on the United States
#' Postal Service website. For a list of all supported subdivision codes,
#' use the [`list_geo_locations`][route53_list_geo_locations] API.
#'
#' @keywords internal
#'
#' @rdname route53_get_geo_location
route53_get_geo_location <- function(ContinentCode = NULL, CountryCode = NULL, SubdivisionCode = NULL) {
  op <- new_operation(
    name = "GetGeoLocation",
    http_method = "GET",
    http_path = "/2013-04-01/geolocation",
    paginator = list()
  )
  input <- .route53$get_geo_location_input(ContinentCode = ContinentCode, CountryCode = CountryCode, SubdivisionCode = SubdivisionCode)
  output <- .route53$get_geo_location_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_geo_location <- route53_get_geo_location

#' Gets information about a specified health check
#'
#' @description
#' Gets information about a specified health check.
#'
#' See [https://paws-r.github.io/docs/route53/get_health_check.html](https://paws-r.github.io/docs/route53/get_health_check.html) for full documentation.
#'
#' @param HealthCheckId &#91;required&#93; The identifier that Amazon Route 53 assigned to the health check when
#' you created it. When you add or update a resource record set, you use
#' this value to specify which health check to use. The value can be up to
#' 64 characters long.
#'
#' @keywords internal
#'
#' @rdname route53_get_health_check
route53_get_health_check <- function(HealthCheckId) {
  op <- new_operation(
    name = "GetHealthCheck",
    http_method = "GET",
    http_path = "/2013-04-01/healthcheck/{HealthCheckId}",
    paginator = list()
  )
  input <- .route53$get_health_check_input(HealthCheckId = HealthCheckId)
  output <- .route53$get_health_check_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_health_check <- route53_get_health_check

#' Retrieves the number of health checks that are associated with the
#' current Amazon Web Services account
#'
#' @description
#' Retrieves the number of health checks that are associated with the current Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/route53/get_health_check_count.html](https://paws-r.github.io/docs/route53/get_health_check_count.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname route53_get_health_check_count
route53_get_health_check_count <- function() {
  op <- new_operation(
    name = "GetHealthCheckCount",
    http_method = "GET",
    http_path = "/2013-04-01/healthcheckcount",
    paginator = list()
  )
  input <- .route53$get_health_check_count_input()
  output <- .route53$get_health_check_count_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_health_check_count <- route53_get_health_check_count

#' Gets the reason that a specified health check failed most recently
#'
#' @description
#' Gets the reason that a specified health check failed most recently.
#'
#' See [https://paws-r.github.io/docs/route53/get_health_check_last_failure_reason.html](https://paws-r.github.io/docs/route53/get_health_check_last_failure_reason.html) for full documentation.
#'
#' @param HealthCheckId &#91;required&#93; The ID for the health check for which you want the last failure reason.
#' When you created the health check,
#' [`create_health_check`][route53_create_health_check] returned the ID in
#' the response, in the `HealthCheckId` element.
#' 
#' If you want to get the last failure reason for a calculated health
#' check, you must use the Amazon Route 53 console or the CloudWatch
#' console. You can't use
#' [`get_health_check_last_failure_reason`][route53_get_health_check_last_failure_reason]
#' for a calculated health check.
#'
#' @keywords internal
#'
#' @rdname route53_get_health_check_last_failure_reason
route53_get_health_check_last_failure_reason <- function(HealthCheckId) {
  op <- new_operation(
    name = "GetHealthCheckLastFailureReason",
    http_method = "GET",
    http_path = "/2013-04-01/healthcheck/{HealthCheckId}/lastfailurereason",
    paginator = list()
  )
  input <- .route53$get_health_check_last_failure_reason_input(HealthCheckId = HealthCheckId)
  output <- .route53$get_health_check_last_failure_reason_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_health_check_last_failure_reason <- route53_get_health_check_last_failure_reason

#' Gets status of a specified health check
#'
#' @description
#' Gets status of a specified health check.
#'
#' See [https://paws-r.github.io/docs/route53/get_health_check_status.html](https://paws-r.github.io/docs/route53/get_health_check_status.html) for full documentation.
#'
#' @param HealthCheckId &#91;required&#93; The ID for the health check that you want the current status for. When
#' you created the health check,
#' [`create_health_check`][route53_create_health_check] returned the ID in
#' the response, in the `HealthCheckId` element.
#' 
#' If you want to check the status of a calculated health check, you must
#' use the Amazon Route 53 console or the CloudWatch console. You can't use
#' [`get_health_check_status`][route53_get_health_check_status] to get the
#' status of a calculated health check.
#'
#' @keywords internal
#'
#' @rdname route53_get_health_check_status
route53_get_health_check_status <- function(HealthCheckId) {
  op <- new_operation(
    name = "GetHealthCheckStatus",
    http_method = "GET",
    http_path = "/2013-04-01/healthcheck/{HealthCheckId}/status",
    paginator = list()
  )
  input <- .route53$get_health_check_status_input(HealthCheckId = HealthCheckId)
  output <- .route53$get_health_check_status_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_health_check_status <- route53_get_health_check_status

#' Gets information about a specified hosted zone including the four name
#' servers assigned to the hosted zone
#'
#' @description
#' Gets information about a specified hosted zone including the four name servers assigned to the hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/get_hosted_zone.html](https://paws-r.github.io/docs/route53/get_hosted_zone.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the hosted zone that you want to get information about.
#'
#' @keywords internal
#'
#' @rdname route53_get_hosted_zone
route53_get_hosted_zone <- function(Id) {
  op <- new_operation(
    name = "GetHostedZone",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzone/{Id}",
    paginator = list()
  )
  input <- .route53$get_hosted_zone_input(Id = Id)
  output <- .route53$get_hosted_zone_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_hosted_zone <- route53_get_hosted_zone

#' Retrieves the number of hosted zones that are associated with the
#' current Amazon Web Services account
#'
#' @description
#' Retrieves the number of hosted zones that are associated with the current Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/route53/get_hosted_zone_count.html](https://paws-r.github.io/docs/route53/get_hosted_zone_count.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname route53_get_hosted_zone_count
route53_get_hosted_zone_count <- function() {
  op <- new_operation(
    name = "GetHostedZoneCount",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzonecount",
    paginator = list()
  )
  input <- .route53$get_hosted_zone_count_input()
  output <- .route53$get_hosted_zone_count_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_hosted_zone_count <- route53_get_hosted_zone_count

#' Gets the specified limit for a specified hosted zone, for example, the
#' maximum number of records that you can create in the hosted zone
#'
#' @description
#' Gets the specified limit for a specified hosted zone, for example, the maximum number of records that you can create in the hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/get_hosted_zone_limit.html](https://paws-r.github.io/docs/route53/get_hosted_zone_limit.html) for full documentation.
#'
#' @param Type &#91;required&#93; The limit that you want to get. Valid values include the following:
#' 
#' -   **MAX_RRSETS_BY_ZONE**: The maximum number of records that you can
#'     create in the specified hosted zone.
#' 
#' -   **MAX_VPCS_ASSOCIATED_BY_ZONE**: The maximum number of Amazon VPCs
#'     that you can associate with the specified private hosted zone.
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone that you want to get a limit for.
#'
#' @keywords internal
#'
#' @rdname route53_get_hosted_zone_limit
route53_get_hosted_zone_limit <- function(Type, HostedZoneId) {
  op <- new_operation(
    name = "GetHostedZoneLimit",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzonelimit/{Id}/{Type}",
    paginator = list()
  )
  input <- .route53$get_hosted_zone_limit_input(Type = Type, HostedZoneId = HostedZoneId)
  output <- .route53$get_hosted_zone_limit_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_hosted_zone_limit <- route53_get_hosted_zone_limit

#' Gets information about a specified configuration for DNS query logging
#'
#' @description
#' Gets information about a specified configuration for DNS query logging.
#'
#' See [https://paws-r.github.io/docs/route53/get_query_logging_config.html](https://paws-r.github.io/docs/route53/get_query_logging_config.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the configuration for DNS query logging that you want to get
#' information about.
#'
#' @keywords internal
#'
#' @rdname route53_get_query_logging_config
route53_get_query_logging_config <- function(Id) {
  op <- new_operation(
    name = "GetQueryLoggingConfig",
    http_method = "GET",
    http_path = "/2013-04-01/queryloggingconfig/{Id}",
    paginator = list()
  )
  input <- .route53$get_query_logging_config_input(Id = Id)
  output <- .route53$get_query_logging_config_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_query_logging_config <- route53_get_query_logging_config

#' Retrieves information about a specified reusable delegation set,
#' including the four name servers that are assigned to the delegation set
#'
#' @description
#' Retrieves information about a specified reusable delegation set, including the four name servers that are assigned to the delegation set.
#'
#' See [https://paws-r.github.io/docs/route53/get_reusable_delegation_set.html](https://paws-r.github.io/docs/route53/get_reusable_delegation_set.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the reusable delegation set that you want to get a list of
#' name servers for.
#'
#' @keywords internal
#'
#' @rdname route53_get_reusable_delegation_set
route53_get_reusable_delegation_set <- function(Id) {
  op <- new_operation(
    name = "GetReusableDelegationSet",
    http_method = "GET",
    http_path = "/2013-04-01/delegationset/{Id}",
    paginator = list()
  )
  input <- .route53$get_reusable_delegation_set_input(Id = Id)
  output <- .route53$get_reusable_delegation_set_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_reusable_delegation_set <- route53_get_reusable_delegation_set

#' Gets the maximum number of hosted zones that you can associate with the
#' specified reusable delegation set
#'
#' @description
#' Gets the maximum number of hosted zones that you can associate with the specified reusable delegation set.
#'
#' See [https://paws-r.github.io/docs/route53/get_reusable_delegation_set_limit.html](https://paws-r.github.io/docs/route53/get_reusable_delegation_set_limit.html) for full documentation.
#'
#' @param Type &#91;required&#93; Specify `MAX_ZONES_BY_REUSABLE_DELEGATION_SET` to get the maximum number
#' of hosted zones that you can associate with the specified reusable
#' delegation set.
#' @param DelegationSetId &#91;required&#93; The ID of the delegation set that you want to get the limit for.
#'
#' @keywords internal
#'
#' @rdname route53_get_reusable_delegation_set_limit
route53_get_reusable_delegation_set_limit <- function(Type, DelegationSetId) {
  op <- new_operation(
    name = "GetReusableDelegationSetLimit",
    http_method = "GET",
    http_path = "/2013-04-01/reusabledelegationsetlimit/{Id}/{Type}",
    paginator = list()
  )
  input <- .route53$get_reusable_delegation_set_limit_input(Type = Type, DelegationSetId = DelegationSetId)
  output <- .route53$get_reusable_delegation_set_limit_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_reusable_delegation_set_limit <- route53_get_reusable_delegation_set_limit

#' Gets information about a specific traffic policy version
#'
#' @description
#' Gets information about a specific traffic policy version.
#'
#' See [https://paws-r.github.io/docs/route53/get_traffic_policy.html](https://paws-r.github.io/docs/route53/get_traffic_policy.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the traffic policy that you want to get information about.
#' @param Version &#91;required&#93; The version number of the traffic policy that you want to get
#' information about.
#'
#' @keywords internal
#'
#' @rdname route53_get_traffic_policy
route53_get_traffic_policy <- function(Id, Version) {
  op <- new_operation(
    name = "GetTrafficPolicy",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicy/{Id}/{Version}",
    paginator = list()
  )
  input <- .route53$get_traffic_policy_input(Id = Id, Version = Version)
  output <- .route53$get_traffic_policy_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_traffic_policy <- route53_get_traffic_policy

#' Gets information about a specified traffic policy instance
#'
#' @description
#' Gets information about a specified traffic policy instance.
#'
#' See [https://paws-r.github.io/docs/route53/get_traffic_policy_instance.html](https://paws-r.github.io/docs/route53/get_traffic_policy_instance.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the traffic policy instance that you want to get information
#' about.
#'
#' @keywords internal
#'
#' @rdname route53_get_traffic_policy_instance
route53_get_traffic_policy_instance <- function(Id) {
  op <- new_operation(
    name = "GetTrafficPolicyInstance",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicyinstance/{Id}",
    paginator = list()
  )
  input <- .route53$get_traffic_policy_instance_input(Id = Id)
  output <- .route53$get_traffic_policy_instance_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_traffic_policy_instance <- route53_get_traffic_policy_instance

#' Gets the number of traffic policy instances that are associated with the
#' current Amazon Web Services account
#'
#' @description
#' Gets the number of traffic policy instances that are associated with the current Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/route53/get_traffic_policy_instance_count.html](https://paws-r.github.io/docs/route53/get_traffic_policy_instance_count.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname route53_get_traffic_policy_instance_count
route53_get_traffic_policy_instance_count <- function() {
  op <- new_operation(
    name = "GetTrafficPolicyInstanceCount",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicyinstancecount",
    paginator = list()
  )
  input <- .route53$get_traffic_policy_instance_count_input()
  output <- .route53$get_traffic_policy_instance_count_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_traffic_policy_instance_count <- route53_get_traffic_policy_instance_count

#' Returns a paginated list of location objects and their CIDR blocks
#'
#' @description
#' Returns a paginated list of location objects and their CIDR blocks.
#'
#' See [https://paws-r.github.io/docs/route53/list_cidr_blocks.html](https://paws-r.github.io/docs/route53/list_cidr_blocks.html) for full documentation.
#'
#' @param CollectionId &#91;required&#93; The UUID of the CIDR collection.
#' @param LocationName The name of the CIDR collection location.
#' @param NextToken An opaque pagination token to indicate where the service is to begin
#' enumerating results.
#' @param MaxResults Maximum number of results you want returned.
#'
#' @keywords internal
#'
#' @rdname route53_list_cidr_blocks
route53_list_cidr_blocks <- function(CollectionId, LocationName = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCidrBlocks",
    http_method = "GET",
    http_path = "/2013-04-01/cidrcollection/{CidrCollectionId}/cidrblocks",
    paginator = list()
  )
  input <- .route53$list_cidr_blocks_input(CollectionId = CollectionId, LocationName = LocationName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .route53$list_cidr_blocks_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_cidr_blocks <- route53_list_cidr_blocks

#' Returns a paginated list of CIDR collections in the Amazon Web Services
#' account (metadata only)
#'
#' @description
#' Returns a paginated list of CIDR collections in the Amazon Web Services account (metadata only).
#'
#' See [https://paws-r.github.io/docs/route53/list_cidr_collections.html](https://paws-r.github.io/docs/route53/list_cidr_collections.html) for full documentation.
#'
#' @param NextToken An opaque pagination token to indicate where the service is to begin
#' enumerating results.
#' 
#' If no value is provided, the listing of results starts from the
#' beginning.
#' @param MaxResults The maximum number of CIDR collections to return in the response.
#'
#' @keywords internal
#'
#' @rdname route53_list_cidr_collections
route53_list_cidr_collections <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCidrCollections",
    http_method = "GET",
    http_path = "/2013-04-01/cidrcollection",
    paginator = list()
  )
  input <- .route53$list_cidr_collections_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .route53$list_cidr_collections_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_cidr_collections <- route53_list_cidr_collections

#' Returns a paginated list of CIDR locations for the given collection
#' (metadata only, does not include CIDR blocks)
#'
#' @description
#' Returns a paginated list of CIDR locations for the given collection (metadata only, does not include CIDR blocks).
#'
#' See [https://paws-r.github.io/docs/route53/list_cidr_locations.html](https://paws-r.github.io/docs/route53/list_cidr_locations.html) for full documentation.
#'
#' @param CollectionId &#91;required&#93; The CIDR collection ID.
#' @param NextToken An opaque pagination token to indicate where the service is to begin
#' enumerating results.
#' 
#' If no value is provided, the listing of results starts from the
#' beginning.
#' @param MaxResults The maximum number of CIDR collection locations to return in the
#' response.
#'
#' @keywords internal
#'
#' @rdname route53_list_cidr_locations
route53_list_cidr_locations <- function(CollectionId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCidrLocations",
    http_method = "GET",
    http_path = "/2013-04-01/cidrcollection/{CidrCollectionId}",
    paginator = list()
  )
  input <- .route53$list_cidr_locations_input(CollectionId = CollectionId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .route53$list_cidr_locations_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_cidr_locations <- route53_list_cidr_locations

#' Retrieves a list of supported geographic locations
#'
#' @description
#' Retrieves a list of supported geographic locations.
#'
#' See [https://paws-r.github.io/docs/route53/list_geo_locations.html](https://paws-r.github.io/docs/route53/list_geo_locations.html) for full documentation.
#'
#' @param StartContinentCode The code for the continent with which you want to start listing
#' locations that Amazon Route 53 supports for geolocation. If Route 53 has
#' already returned a page or more of results, if `IsTruncated` is true,
#' and if `NextContinentCode` from the previous response has a value, enter
#' that value in `startcontinentcode` to return the next page of results.
#' 
#' Include `startcontinentcode` only if you want to list continents. Don't
#' include `startcontinentcode` when you're listing countries or countries
#' with their subdivisions.
#' @param StartCountryCode The code for the country with which you want to start listing locations
#' that Amazon Route 53 supports for geolocation. If Route 53 has already
#' returned a page or more of results, if `IsTruncated` is `true`, and if
#' `NextCountryCode` from the previous response has a value, enter that
#' value in `startcountrycode` to return the next page of results.
#' @param StartSubdivisionCode The code for the state of the United States with which you want to start
#' listing locations that Amazon Route 53 supports for geolocation. If
#' Route 53 has already returned a page or more of results, if
#' `IsTruncated` is `true`, and if `NextSubdivisionCode` from the previous
#' response has a value, enter that value in `startsubdivisioncode` to
#' return the next page of results.
#' 
#' To list subdivisions (U.S. states), you must include both
#' `startcountrycode` and `startsubdivisioncode`.
#' @param MaxItems (Optional) The maximum number of geolocations to be included in the
#' response body for this request. If more than `maxitems` geolocations
#' remain to be listed, then the value of the `IsTruncated` element in the
#' response is `true`.
#'
#' @keywords internal
#'
#' @rdname route53_list_geo_locations
route53_list_geo_locations <- function(StartContinentCode = NULL, StartCountryCode = NULL, StartSubdivisionCode = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListGeoLocations",
    http_method = "GET",
    http_path = "/2013-04-01/geolocations",
    paginator = list()
  )
  input <- .route53$list_geo_locations_input(StartContinentCode = StartContinentCode, StartCountryCode = StartCountryCode, StartSubdivisionCode = StartSubdivisionCode, MaxItems = MaxItems)
  output <- .route53$list_geo_locations_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_geo_locations <- route53_list_geo_locations

#' Retrieve a list of the health checks that are associated with the
#' current Amazon Web Services account
#'
#' @description
#' Retrieve a list of the health checks that are associated with the current Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/route53/list_health_checks.html](https://paws-r.github.io/docs/route53/list_health_checks.html) for full documentation.
#'
#' @param Marker If the value of `IsTruncated` in the previous response was `true`, you
#' have more health checks. To get another group, submit another
#' [`list_health_checks`][route53_list_health_checks] request.
#' 
#' For the value of `marker`, specify the value of `NextMarker` from the
#' previous response, which is the ID of the first health check that Amazon
#' Route 53 will return if you submit another request.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more health checks to get.
#' @param MaxItems The maximum number of health checks that you want
#' [`list_health_checks`][route53_list_health_checks] to return in response
#' to the current request. Amazon Route 53 returns a maximum of 100 items.
#' If you set `MaxItems` to a value greater than 100, Route 53 returns only
#' the first 100 health checks.
#'
#' @keywords internal
#'
#' @rdname route53_list_health_checks
route53_list_health_checks <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListHealthChecks",
    http_method = "GET",
    http_path = "/2013-04-01/healthcheck",
    paginator = list()
  )
  input <- .route53$list_health_checks_input(Marker = Marker, MaxItems = MaxItems)
  output <- .route53$list_health_checks_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_health_checks <- route53_list_health_checks

#' Retrieves a list of the public and private hosted zones that are
#' associated with the current Amazon Web Services account
#'
#' @description
#' Retrieves a list of the public and private hosted zones that are associated with the current Amazon Web Services account. The response includes a `HostedZones` child element for each hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/list_hosted_zones.html](https://paws-r.github.io/docs/route53/list_hosted_zones.html) for full documentation.
#'
#' @param Marker If the value of `IsTruncated` in the previous response was `true`, you
#' have more hosted zones. To get more hosted zones, submit another
#' [`list_hosted_zones`][route53_list_hosted_zones] request.
#' 
#' For the value of `marker`, specify the value of `NextMarker` from the
#' previous response, which is the ID of the first hosted zone that Amazon
#' Route 53 will return if you submit another request.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more hosted zones to get.
#' @param MaxItems (Optional) The maximum number of hosted zones that you want Amazon Route
#' 53 to return. If you have more than `maxitems` hosted zones, the value
#' of `IsTruncated` in the response is `true`, and the value of
#' `NextMarker` is the hosted zone ID of the first hosted zone that Route
#' 53 will return if you submit another request.
#' @param DelegationSetId If you're using reusable delegation sets and you want to list all of the
#' hosted zones that are associated with a reusable delegation set, specify
#' the ID of that reusable delegation set.
#'
#' @keywords internal
#'
#' @rdname route53_list_hosted_zones
route53_list_hosted_zones <- function(Marker = NULL, MaxItems = NULL, DelegationSetId = NULL) {
  op <- new_operation(
    name = "ListHostedZones",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzone",
    paginator = list()
  )
  input <- .route53$list_hosted_zones_input(Marker = Marker, MaxItems = MaxItems, DelegationSetId = DelegationSetId)
  output <- .route53$list_hosted_zones_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_hosted_zones <- route53_list_hosted_zones

#' Retrieves a list of your hosted zones in lexicographic order
#'
#' @description
#' Retrieves a list of your hosted zones in lexicographic order. The response includes a `HostedZones` child element for each hosted zone created by the current Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/route53/list_hosted_zones_by_name.html](https://paws-r.github.io/docs/route53/list_hosted_zones_by_name.html) for full documentation.
#'
#' @param DNSName (Optional) For your first request to
#' [`list_hosted_zones_by_name`][route53_list_hosted_zones_by_name],
#' include the `dnsname` parameter only if you want to specify the name of
#' the first hosted zone in the response. If you don't include the
#' `dnsname` parameter, Amazon Route 53 returns all of the hosted zones
#' that were created by the current Amazon Web Services account, in ASCII
#' order. For subsequent requests, include both `dnsname` and
#' `hostedzoneid` parameters. For `dnsname`, specify the value of
#' `NextDNSName` from the previous response.
#' @param HostedZoneId (Optional) For your first request to
#' [`list_hosted_zones_by_name`][route53_list_hosted_zones_by_name], do not
#' include the `hostedzoneid` parameter.
#' 
#' If you have more hosted zones than the value of `maxitems`,
#' [`list_hosted_zones_by_name`][route53_list_hosted_zones_by_name] returns
#' only the first `maxitems` hosted zones. To get the next group of
#' `maxitems` hosted zones, submit another request to
#' [`list_hosted_zones_by_name`][route53_list_hosted_zones_by_name] and
#' include both `dnsname` and `hostedzoneid` parameters. For the value of
#' `hostedzoneid`, specify the value of the `NextHostedZoneId` element from
#' the previous response.
#' @param MaxItems The maximum number of hosted zones to be included in the response body
#' for this request. If you have more than `maxitems` hosted zones, then
#' the value of the `IsTruncated` element in the response is true, and the
#' values of `NextDNSName` and `NextHostedZoneId` specify the first hosted
#' zone in the next group of `maxitems` hosted zones.
#'
#' @keywords internal
#'
#' @rdname route53_list_hosted_zones_by_name
route53_list_hosted_zones_by_name <- function(DNSName = NULL, HostedZoneId = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListHostedZonesByName",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzonesbyname",
    paginator = list()
  )
  input <- .route53$list_hosted_zones_by_name_input(DNSName = DNSName, HostedZoneId = HostedZoneId, MaxItems = MaxItems)
  output <- .route53$list_hosted_zones_by_name_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_hosted_zones_by_name <- route53_list_hosted_zones_by_name

#' Lists all the private hosted zones that a specified VPC is associated
#' with, regardless of which Amazon Web Services account or Amazon Web
#' Services service owns the hosted zones
#'
#' @description
#' Lists all the private hosted zones that a specified VPC is associated with, regardless of which Amazon Web Services account or Amazon Web Services service owns the hosted zones. The `HostedZoneOwner` structure in the response contains one of the following values:
#'
#' See [https://paws-r.github.io/docs/route53/list_hosted_zones_by_vpc.html](https://paws-r.github.io/docs/route53/list_hosted_zones_by_vpc.html) for full documentation.
#'
#' @param VPCId &#91;required&#93; The ID of the Amazon VPC that you want to list hosted zones for.
#' @param VPCRegion &#91;required&#93; For the Amazon VPC that you specified for `VPCId`, the Amazon Web
#' Services Region that you created the VPC in.
#' @param MaxItems (Optional) The maximum number of hosted zones that you want Amazon Route
#' 53 to return. If the specified VPC is associated with more than
#' `MaxItems` hosted zones, the response includes a `NextToken` element.
#' `NextToken` contains an encrypted token that identifies the first hosted
#' zone that Route 53 will return if you submit another request.
#' @param NextToken If the previous response included a `NextToken` element, the specified
#' VPC is associated with more hosted zones. To get more hosted zones,
#' submit another
#' [`list_hosted_zones_by_vpc`][route53_list_hosted_zones_by_vpc] request.
#' 
#' For the value of `NextToken`, specify the value of `NextToken` from the
#' previous response.
#' 
#' If the previous response didn't include a `NextToken` element, there are
#' no more hosted zones to get.
#'
#' @keywords internal
#'
#' @rdname route53_list_hosted_zones_by_vpc
route53_list_hosted_zones_by_vpc <- function(VPCId, VPCRegion, MaxItems = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListHostedZonesByVPC",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzonesbyvpc",
    paginator = list()
  )
  input <- .route53$list_hosted_zones_by_vpc_input(VPCId = VPCId, VPCRegion = VPCRegion, MaxItems = MaxItems, NextToken = NextToken)
  output <- .route53$list_hosted_zones_by_vpc_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_hosted_zones_by_vpc <- route53_list_hosted_zones_by_vpc

#' Lists the configurations for DNS query logging that are associated with
#' the current Amazon Web Services account or the configuration that is
#' associated with a specified hosted zone
#'
#' @description
#' Lists the configurations for DNS query logging that are associated with the current Amazon Web Services account or the configuration that is associated with a specified hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/list_query_logging_configs.html](https://paws-r.github.io/docs/route53/list_query_logging_configs.html) for full documentation.
#'
#' @param HostedZoneId (Optional) If you want to list the query logging configuration that is
#' associated with a hosted zone, specify the ID in `HostedZoneId`.
#' 
#' If you don't specify a hosted zone ID,
#' [`list_query_logging_configs`][route53_list_query_logging_configs]
#' returns all of the configurations that are associated with the current
#' Amazon Web Services account.
#' @param NextToken (Optional) If the current Amazon Web Services account has more than
#' `MaxResults` query logging configurations, use `NextToken` to get the
#' second and subsequent pages of results.
#' 
#' For the first
#' [`list_query_logging_configs`][route53_list_query_logging_configs]
#' request, omit this value.
#' 
#' For the second and subsequent requests, get the value of `NextToken`
#' from the previous response and specify that value for `NextToken` in the
#' request.
#' @param MaxResults (Optional) The maximum number of query logging configurations that you
#' want Amazon Route 53 to return in response to the current request. If
#' the current Amazon Web Services account has more than `MaxResults`
#' configurations, use the value of
#' [NextToken](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax)
#' in the response to get the next page of results.
#' 
#' If you don't specify a value for `MaxResults`, Route 53 returns up to
#' 100 configurations.
#'
#' @keywords internal
#'
#' @rdname route53_list_query_logging_configs
route53_list_query_logging_configs <- function(HostedZoneId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListQueryLoggingConfigs",
    http_method = "GET",
    http_path = "/2013-04-01/queryloggingconfig",
    paginator = list()
  )
  input <- .route53$list_query_logging_configs_input(HostedZoneId = HostedZoneId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .route53$list_query_logging_configs_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_query_logging_configs <- route53_list_query_logging_configs

#' Lists the resource record sets in a specified hosted zone
#'
#' @description
#' Lists the resource record sets in a specified hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/list_resource_record_sets.html](https://paws-r.github.io/docs/route53/list_resource_record_sets.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone that contains the resource record sets that
#' you want to list.
#' @param StartRecordName The first name in the lexicographic ordering of resource record sets
#' that you want to list. If the specified record name doesn't exist, the
#' results begin with the first resource record set that has a name greater
#' than the value of `name`.
#' @param StartRecordType The type of resource record set to begin the record listing from.
#' 
#' Valid values for basic resource record sets: `A` | `AAAA` | `CAA` |
#' `CNAME` | `MX` | `NAPTR` | `NS` | `PTR` | `SOA` | `SPF` | `SRV` | `TXT`
#' 
#' Values for weighted, latency, geolocation, and failover resource record
#' sets: `A` | `AAAA` | `CAA` | `CNAME` | `MX` | `NAPTR` | `PTR` | `SPF` |
#' `SRV` | `TXT`
#' 
#' Values for alias resource record sets:
#' 
#' -   **API Gateway custom regional API or edge-optimized API**: A
#' 
#' -   **CloudFront distribution**: A or AAAA
#' 
#' -   **Elastic Beanstalk environment that has a regionalized subdomain**:
#'     A
#' 
#' -   **Elastic Load Balancing load balancer**: A | AAAA
#' 
#' -   **S3 bucket**: A
#' 
#' -   **VPC interface VPC endpoint**: A
#' 
#' -   **Another resource record set in this hosted zone:** The type of the
#'     resource record set that the alias references.
#' 
#' Constraint: Specifying `type` without specifying `name` returns an
#' `InvalidInput` error.
#' @param StartRecordIdentifier *Resource record sets that have a routing policy other than simple:* If
#' results were truncated for a given DNS name and type, specify the value
#' of `NextRecordIdentifier` from the previous response to get the next
#' resource record set that has the current DNS name and type.
#' @param MaxItems (Optional) The maximum number of resource records sets to include in the
#' response body for this request. If the response includes more than
#' `maxitems` resource record sets, the value of the `IsTruncated` element
#' in the response is `true`, and the values of the `NextRecordName` and
#' `NextRecordType` elements in the response identify the first resource
#' record set in the next group of `maxitems` resource record sets.
#'
#' @keywords internal
#'
#' @rdname route53_list_resource_record_sets
route53_list_resource_record_sets <- function(HostedZoneId, StartRecordName = NULL, StartRecordType = NULL, StartRecordIdentifier = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListResourceRecordSets",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzone/{Id}/rrset",
    paginator = list()
  )
  input <- .route53$list_resource_record_sets_input(HostedZoneId = HostedZoneId, StartRecordName = StartRecordName, StartRecordType = StartRecordType, StartRecordIdentifier = StartRecordIdentifier, MaxItems = MaxItems)
  output <- .route53$list_resource_record_sets_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_resource_record_sets <- route53_list_resource_record_sets

#' Retrieves a list of the reusable delegation sets that are associated
#' with the current Amazon Web Services account
#'
#' @description
#' Retrieves a list of the reusable delegation sets that are associated with the current Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/route53/list_reusable_delegation_sets.html](https://paws-r.github.io/docs/route53/list_reusable_delegation_sets.html) for full documentation.
#'
#' @param Marker If the value of `IsTruncated` in the previous response was `true`, you
#' have more reusable delegation sets. To get another group, submit another
#' [`list_reusable_delegation_sets`][route53_list_reusable_delegation_sets]
#' request.
#' 
#' For the value of `marker`, specify the value of `NextMarker` from the
#' previous response, which is the ID of the first reusable delegation set
#' that Amazon Route 53 will return if you submit another request.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more reusable delegation sets to get.
#' @param MaxItems The number of reusable delegation sets that you want Amazon Route 53 to
#' return in the response to this request. If you specify a value greater
#' than 100, Route 53 returns only the first 100 reusable delegation sets.
#'
#' @keywords internal
#'
#' @rdname route53_list_reusable_delegation_sets
route53_list_reusable_delegation_sets <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListReusableDelegationSets",
    http_method = "GET",
    http_path = "/2013-04-01/delegationset",
    paginator = list()
  )
  input <- .route53$list_reusable_delegation_sets_input(Marker = Marker, MaxItems = MaxItems)
  output <- .route53$list_reusable_delegation_sets_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_reusable_delegation_sets <- route53_list_reusable_delegation_sets

#' Lists tags for one health check or hosted zone
#'
#' @description
#' Lists tags for one health check or hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/list_tags_for_resource.html](https://paws-r.github.io/docs/route53/list_tags_for_resource.html) for full documentation.
#'
#' @param ResourceType &#91;required&#93; The type of the resource.
#' 
#' -   The resource type for health checks is `healthcheck`.
#' 
#' -   The resource type for hosted zones is `hostedzone`.
#' @param ResourceId &#91;required&#93; The ID of the resource for which you want to retrieve tags.
#'
#' @keywords internal
#'
#' @rdname route53_list_tags_for_resource
route53_list_tags_for_resource <- function(ResourceType, ResourceId) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/2013-04-01/tags/{ResourceType}/{ResourceId}",
    paginator = list()
  )
  input <- .route53$list_tags_for_resource_input(ResourceType = ResourceType, ResourceId = ResourceId)
  output <- .route53$list_tags_for_resource_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_tags_for_resource <- route53_list_tags_for_resource

#' Lists tags for up to 10 health checks or hosted zones
#'
#' @description
#' Lists tags for up to 10 health checks or hosted zones.
#'
#' See [https://paws-r.github.io/docs/route53/list_tags_for_resources.html](https://paws-r.github.io/docs/route53/list_tags_for_resources.html) for full documentation.
#'
#' @param ResourceType &#91;required&#93; The type of the resources.
#' 
#' -   The resource type for health checks is `healthcheck`.
#' 
#' -   The resource type for hosted zones is `hostedzone`.
#' @param ResourceIds &#91;required&#93; A complex type that contains the ResourceId element for each resource
#' for which you want to get a list of tags.
#'
#' @keywords internal
#'
#' @rdname route53_list_tags_for_resources
route53_list_tags_for_resources <- function(ResourceType, ResourceIds) {
  op <- new_operation(
    name = "ListTagsForResources",
    http_method = "POST",
    http_path = "/2013-04-01/tags/{ResourceType}",
    paginator = list()
  )
  input <- .route53$list_tags_for_resources_input(ResourceType = ResourceType, ResourceIds = ResourceIds)
  output <- .route53$list_tags_for_resources_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_tags_for_resources <- route53_list_tags_for_resources

#' Gets information about the latest version for every traffic policy that
#' is associated with the current Amazon Web Services account
#'
#' @description
#' Gets information about the latest version for every traffic policy that is associated with the current Amazon Web Services account. Policies are listed in the order that they were created in.
#'
#' See [https://paws-r.github.io/docs/route53/list_traffic_policies.html](https://paws-r.github.io/docs/route53/list_traffic_policies.html) for full documentation.
#'
#' @param TrafficPolicyIdMarker (Conditional) For your first request to
#' [`list_traffic_policies`][route53_list_traffic_policies], don't include
#' the `TrafficPolicyIdMarker` parameter.
#' 
#' If you have more traffic policies than the value of `MaxItems`,
#' [`list_traffic_policies`][route53_list_traffic_policies] returns only
#' the first `MaxItems` traffic policies. To get the next group of
#' policies, submit another request to
#' [`list_traffic_policies`][route53_list_traffic_policies]. For the value
#' of `TrafficPolicyIdMarker`, specify the value of `TrafficPolicyIdMarker`
#' that was returned in the previous response.
#' @param MaxItems (Optional) The maximum number of traffic policies that you want Amazon
#' Route 53 to return in response to this request. If you have more than
#' `MaxItems` traffic policies, the value of `IsTruncated` in the response
#' is `true`, and the value of `TrafficPolicyIdMarker` is the ID of the
#' first traffic policy that Route 53 will return if you submit another
#' request.
#'
#' @keywords internal
#'
#' @rdname route53_list_traffic_policies
route53_list_traffic_policies <- function(TrafficPolicyIdMarker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListTrafficPolicies",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicies",
    paginator = list()
  )
  input <- .route53$list_traffic_policies_input(TrafficPolicyIdMarker = TrafficPolicyIdMarker, MaxItems = MaxItems)
  output <- .route53$list_traffic_policies_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_traffic_policies <- route53_list_traffic_policies

#' Gets information about the traffic policy instances that you created by
#' using the current Amazon Web Services account
#'
#' @description
#' Gets information about the traffic policy instances that you created by using the current Amazon Web Services account.
#'
#' See [https://paws-r.github.io/docs/route53/list_traffic_policy_instances.html](https://paws-r.github.io/docs/route53/list_traffic_policy_instances.html) for full documentation.
#'
#' @param HostedZoneIdMarker If the value of `IsTruncated` in the previous response was `true`, you
#' have more traffic policy instances. To get more traffic policy
#' instances, submit another
#' [`list_traffic_policy_instances`][route53_list_traffic_policy_instances]
#' request. For the value of `HostedZoneId`, specify the value of
#' `HostedZoneIdMarker` from the previous response, which is the hosted
#' zone ID of the first traffic policy instance in the next group of
#' traffic policy instances.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param TrafficPolicyInstanceNameMarker If the value of `IsTruncated` in the previous response was `true`, you
#' have more traffic policy instances. To get more traffic policy
#' instances, submit another
#' [`list_traffic_policy_instances`][route53_list_traffic_policy_instances]
#' request. For the value of `trafficpolicyinstancename`, specify the value
#' of `TrafficPolicyInstanceNameMarker` from the previous response, which
#' is the name of the first traffic policy instance in the next group of
#' traffic policy instances.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param TrafficPolicyInstanceTypeMarker If the value of `IsTruncated` in the previous response was `true`, you
#' have more traffic policy instances. To get more traffic policy
#' instances, submit another
#' [`list_traffic_policy_instances`][route53_list_traffic_policy_instances]
#' request. For the value of `trafficpolicyinstancetype`, specify the value
#' of `TrafficPolicyInstanceTypeMarker` from the previous response, which
#' is the type of the first traffic policy instance in the next group of
#' traffic policy instances.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param MaxItems The maximum number of traffic policy instances that you want Amazon
#' Route 53 to return in response to a
#' [`list_traffic_policy_instances`][route53_list_traffic_policy_instances]
#' request. If you have more than `MaxItems` traffic policy instances, the
#' value of the `IsTruncated` element in the response is `true`, and the
#' values of `HostedZoneIdMarker`, `TrafficPolicyInstanceNameMarker`, and
#' `TrafficPolicyInstanceTypeMarker` represent the first traffic policy
#' instance in the next group of `MaxItems` traffic policy instances.
#'
#' @keywords internal
#'
#' @rdname route53_list_traffic_policy_instances
route53_list_traffic_policy_instances <- function(HostedZoneIdMarker = NULL, TrafficPolicyInstanceNameMarker = NULL, TrafficPolicyInstanceTypeMarker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListTrafficPolicyInstances",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicyinstances",
    paginator = list()
  )
  input <- .route53$list_traffic_policy_instances_input(HostedZoneIdMarker = HostedZoneIdMarker, TrafficPolicyInstanceNameMarker = TrafficPolicyInstanceNameMarker, TrafficPolicyInstanceTypeMarker = TrafficPolicyInstanceTypeMarker, MaxItems = MaxItems)
  output <- .route53$list_traffic_policy_instances_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_traffic_policy_instances <- route53_list_traffic_policy_instances

#' Gets information about the traffic policy instances that you created in
#' a specified hosted zone
#'
#' @description
#' Gets information about the traffic policy instances that you created in a specified hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/list_traffic_policy_instances_by_hosted_zone.html](https://paws-r.github.io/docs/route53/list_traffic_policy_instances_by_hosted_zone.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone that you want to list traffic policy instances
#' for.
#' @param TrafficPolicyInstanceNameMarker If the value of `IsTruncated` in the previous response is true, you have
#' more traffic policy instances. To get more traffic policy instances,
#' submit another
#' [`list_traffic_policy_instances`][route53_list_traffic_policy_instances]
#' request. For the value of `trafficpolicyinstancename`, specify the value
#' of `TrafficPolicyInstanceNameMarker` from the previous response, which
#' is the name of the first traffic policy instance in the next group of
#' traffic policy instances.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param TrafficPolicyInstanceTypeMarker If the value of `IsTruncated` in the previous response is true, you have
#' more traffic policy instances. To get more traffic policy instances,
#' submit another
#' [`list_traffic_policy_instances`][route53_list_traffic_policy_instances]
#' request. For the value of `trafficpolicyinstancetype`, specify the value
#' of `TrafficPolicyInstanceTypeMarker` from the previous response, which
#' is the type of the first traffic policy instance in the next group of
#' traffic policy instances.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param MaxItems The maximum number of traffic policy instances to be included in the
#' response body for this request. If you have more than `MaxItems` traffic
#' policy instances, the value of the `IsTruncated` element in the response
#' is `true`, and the values of `HostedZoneIdMarker`,
#' `TrafficPolicyInstanceNameMarker`, and `TrafficPolicyInstanceTypeMarker`
#' represent the first traffic policy instance that Amazon Route 53 will
#' return if you submit another request.
#'
#' @keywords internal
#'
#' @rdname route53_list_traffic_policy_instances_by_hosted_zone
route53_list_traffic_policy_instances_by_hosted_zone <- function(HostedZoneId, TrafficPolicyInstanceNameMarker = NULL, TrafficPolicyInstanceTypeMarker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListTrafficPolicyInstancesByHostedZone",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicyinstances/hostedzone",
    paginator = list()
  )
  input <- .route53$list_traffic_policy_instances_by_hosted_zone_input(HostedZoneId = HostedZoneId, TrafficPolicyInstanceNameMarker = TrafficPolicyInstanceNameMarker, TrafficPolicyInstanceTypeMarker = TrafficPolicyInstanceTypeMarker, MaxItems = MaxItems)
  output <- .route53$list_traffic_policy_instances_by_hosted_zone_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_traffic_policy_instances_by_hosted_zone <- route53_list_traffic_policy_instances_by_hosted_zone

#' Gets information about the traffic policy instances that you created by
#' using a specify traffic policy version
#'
#' @description
#' Gets information about the traffic policy instances that you created by using a specify traffic policy version.
#'
#' See [https://paws-r.github.io/docs/route53/list_traffic_policy_instances_by_policy.html](https://paws-r.github.io/docs/route53/list_traffic_policy_instances_by_policy.html) for full documentation.
#'
#' @param TrafficPolicyId &#91;required&#93; The ID of the traffic policy for which you want to list traffic policy
#' instances.
#' @param TrafficPolicyVersion &#91;required&#93; The version of the traffic policy for which you want to list traffic
#' policy instances. The version must be associated with the traffic policy
#' that is specified by `TrafficPolicyId`.
#' @param HostedZoneIdMarker If the value of `IsTruncated` in the previous response was `true`, you
#' have more traffic policy instances. To get more traffic policy
#' instances, submit another
#' [`list_traffic_policy_instances_by_policy`][route53_list_traffic_policy_instances_by_policy]
#' request.
#' 
#' For the value of `hostedzoneid`, specify the value of
#' `HostedZoneIdMarker` from the previous response, which is the hosted
#' zone ID of the first traffic policy instance that Amazon Route 53 will
#' return if you submit another request.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param TrafficPolicyInstanceNameMarker If the value of `IsTruncated` in the previous response was `true`, you
#' have more traffic policy instances. To get more traffic policy
#' instances, submit another
#' [`list_traffic_policy_instances_by_policy`][route53_list_traffic_policy_instances_by_policy]
#' request.
#' 
#' For the value of `trafficpolicyinstancename`, specify the value of
#' `TrafficPolicyInstanceNameMarker` from the previous response, which is
#' the name of the first traffic policy instance that Amazon Route 53 will
#' return if you submit another request.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param TrafficPolicyInstanceTypeMarker If the value of `IsTruncated` in the previous response was `true`, you
#' have more traffic policy instances. To get more traffic policy
#' instances, submit another
#' [`list_traffic_policy_instances_by_policy`][route53_list_traffic_policy_instances_by_policy]
#' request.
#' 
#' For the value of `trafficpolicyinstancetype`, specify the value of
#' `TrafficPolicyInstanceTypeMarker` from the previous response, which is
#' the name of the first traffic policy instance that Amazon Route 53 will
#' return if you submit another request.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param MaxItems The maximum number of traffic policy instances to be included in the
#' response body for this request. If you have more than `MaxItems` traffic
#' policy instances, the value of the `IsTruncated` element in the response
#' is `true`, and the values of `HostedZoneIdMarker`,
#' `TrafficPolicyInstanceNameMarker`, and `TrafficPolicyInstanceTypeMarker`
#' represent the first traffic policy instance that Amazon Route 53 will
#' return if you submit another request.
#'
#' @keywords internal
#'
#' @rdname route53_list_traffic_policy_instances_by_policy
route53_list_traffic_policy_instances_by_policy <- function(TrafficPolicyId, TrafficPolicyVersion, HostedZoneIdMarker = NULL, TrafficPolicyInstanceNameMarker = NULL, TrafficPolicyInstanceTypeMarker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListTrafficPolicyInstancesByPolicy",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicyinstances/trafficpolicy",
    paginator = list()
  )
  input <- .route53$list_traffic_policy_instances_by_policy_input(TrafficPolicyId = TrafficPolicyId, TrafficPolicyVersion = TrafficPolicyVersion, HostedZoneIdMarker = HostedZoneIdMarker, TrafficPolicyInstanceNameMarker = TrafficPolicyInstanceNameMarker, TrafficPolicyInstanceTypeMarker = TrafficPolicyInstanceTypeMarker, MaxItems = MaxItems)
  output <- .route53$list_traffic_policy_instances_by_policy_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_traffic_policy_instances_by_policy <- route53_list_traffic_policy_instances_by_policy

#' Gets information about all of the versions for a specified traffic
#' policy
#'
#' @description
#' Gets information about all of the versions for a specified traffic policy.
#'
#' See [https://paws-r.github.io/docs/route53/list_traffic_policy_versions.html](https://paws-r.github.io/docs/route53/list_traffic_policy_versions.html) for full documentation.
#'
#' @param Id &#91;required&#93; Specify the value of `Id` of the traffic policy for which you want to
#' list all versions.
#' @param TrafficPolicyVersionMarker For your first request to
#' [`list_traffic_policy_versions`][route53_list_traffic_policy_versions],
#' don't include the `TrafficPolicyVersionMarker` parameter.
#' 
#' If you have more traffic policy versions than the value of `MaxItems`,
#' [`list_traffic_policy_versions`][route53_list_traffic_policy_versions]
#' returns only the first group of `MaxItems` versions. To get more traffic
#' policy versions, submit another
#' [`list_traffic_policy_versions`][route53_list_traffic_policy_versions]
#' request. For the value of `TrafficPolicyVersionMarker`, specify the
#' value of `TrafficPolicyVersionMarker` in the previous response.
#' @param MaxItems The maximum number of traffic policy versions that you want Amazon Route
#' 53 to include in the response body for this request. If the specified
#' traffic policy has more than `MaxItems` versions, the value of
#' `IsTruncated` in the response is `true`, and the value of the
#' `TrafficPolicyVersionMarker` element is the ID of the first version that
#' Route 53 will return if you submit another request.
#'
#' @keywords internal
#'
#' @rdname route53_list_traffic_policy_versions
route53_list_traffic_policy_versions <- function(Id, TrafficPolicyVersionMarker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListTrafficPolicyVersions",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicies/{Id}/versions",
    paginator = list()
  )
  input <- .route53$list_traffic_policy_versions_input(Id = Id, TrafficPolicyVersionMarker = TrafficPolicyVersionMarker, MaxItems = MaxItems)
  output <- .route53$list_traffic_policy_versions_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_traffic_policy_versions <- route53_list_traffic_policy_versions

#' Gets a list of the VPCs that were created by other accounts and that can
#' be associated with a specified hosted zone because you've submitted one
#' or more CreateVPCAssociationAuthorization requests
#'
#' @description
#' Gets a list of the VPCs that were created by other accounts and that can be associated with a specified hosted zone because you've submitted one or more [`create_vpc_association_authorization`][route53_create_vpc_association_authorization] requests.
#'
#' See [https://paws-r.github.io/docs/route53/list_vpc_association_authorizations.html](https://paws-r.github.io/docs/route53/list_vpc_association_authorizations.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone for which you want a list of VPCs that can be
#' associated with the hosted zone.
#' @param NextToken *Optional*: If a response includes a `NextToken` element, there are more
#' VPCs that can be associated with the specified hosted zone. To get the
#' next page of results, submit another request, and include the value of
#' `NextToken` from the response in the `nexttoken` parameter in another
#' [`list_vpc_association_authorizations`][route53_list_vpc_association_authorizations]
#' request.
#' @param MaxResults *Optional*: An integer that specifies the maximum number of VPCs that
#' you want Amazon Route 53 to return. If you don't specify a value for
#' `MaxResults`, Route 53 returns up to 50 VPCs per page.
#'
#' @keywords internal
#'
#' @rdname route53_list_vpc_association_authorizations
route53_list_vpc_association_authorizations <- function(HostedZoneId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListVPCAssociationAuthorizations",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzone/{Id}/authorizevpcassociation",
    paginator = list()
  )
  input <- .route53$list_vpc_association_authorizations_input(HostedZoneId = HostedZoneId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .route53$list_vpc_association_authorizations_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_vpc_association_authorizations <- route53_list_vpc_association_authorizations

#' Gets the value that Amazon Route 53 returns in response to a DNS request
#' for a specified record name and type
#'
#' @description
#' Gets the value that Amazon Route 53 returns in response to a DNS request for a specified record name and type. You can optionally specify the IP address of a DNS resolver, an EDNS0 client subnet IP address, and a subnet mask.
#'
#' See [https://paws-r.github.io/docs/route53/test_dns_answer.html](https://paws-r.github.io/docs/route53/test_dns_answer.html) for full documentation.
#'
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone that you want Amazon Route 53 to simulate a
#' query for.
#' @param RecordName &#91;required&#93; The name of the resource record set that you want Amazon Route 53 to
#' simulate a query for.
#' @param RecordType &#91;required&#93; The type of the resource record set.
#' @param ResolverIP If you want to simulate a request from a specific DNS resolver, specify
#' the IP address for that resolver. If you omit this value,
#' `TestDnsAnswer` uses the IP address of a DNS resolver in the Amazon Web
#' Services US East (N. Virginia) Region (`us-east-1`).
#' @param EDNS0ClientSubnetIP If the resolver that you specified for resolverip supports EDNS0,
#' specify the IPv4 or IPv6 address of a client in the applicable location,
#' for example, `192.0.2.44` or `2001:db8:85a3::8a2e:370:7334`.
#' @param EDNS0ClientSubnetMask If you specify an IP address for `edns0clientsubnetip`, you can
#' optionally specify the number of bits of the IP address that you want
#' the checking tool to include in the DNS query. For example, if you
#' specify `192.0.2.44` for `edns0clientsubnetip` and `24` for
#' `edns0clientsubnetmask`, the checking tool will simulate a request from
#' 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64
#' bits for IPv6 addresses.
#' 
#' The range of valid values depends on whether `edns0clientsubnetip` is an
#' IPv4 or an IPv6 address:
#' 
#' -   **IPv4**: Specify a value between 0 and 32
#' 
#' -   **IPv6**: Specify a value between 0 and 128
#'
#' @keywords internal
#'
#' @rdname route53_test_dns_answer
route53_test_dns_answer <- function(HostedZoneId, RecordName, RecordType, ResolverIP = NULL, EDNS0ClientSubnetIP = NULL, EDNS0ClientSubnetMask = NULL) {
  op <- new_operation(
    name = "TestDNSAnswer",
    http_method = "GET",
    http_path = "/2013-04-01/testdnsanswer",
    paginator = list()
  )
  input <- .route53$test_dns_answer_input(HostedZoneId = HostedZoneId, RecordName = RecordName, RecordType = RecordType, ResolverIP = ResolverIP, EDNS0ClientSubnetIP = EDNS0ClientSubnetIP, EDNS0ClientSubnetMask = EDNS0ClientSubnetMask)
  output <- .route53$test_dns_answer_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$test_dns_answer <- route53_test_dns_answer

#' Updates an existing health check
#'
#' @description
#' Updates an existing health check. Note that some values can't be updated.
#'
#' See [https://paws-r.github.io/docs/route53/update_health_check.html](https://paws-r.github.io/docs/route53/update_health_check.html) for full documentation.
#'
#' @param HealthCheckId &#91;required&#93; The ID for the health check for which you want detailed information.
#' When you created the health check,
#' [`create_health_check`][route53_create_health_check] returned the ID in
#' the response, in the `HealthCheckId` element.
#' @param HealthCheckVersion A sequential counter that Amazon Route 53 sets to `1` when you create a
#' health check and increments by 1 each time you update settings for the
#' health check.
#' 
#' We recommend that you use [`get_health_check`][route53_get_health_check]
#' or [`list_health_checks`][route53_list_health_checks] to get the current
#' value of `HealthCheckVersion` for the health check that you want to
#' update, and that you include that value in your
#' [`update_health_check`][route53_update_health_check] request. This
#' prevents Route 53 from overwriting an intervening update:
#' 
#' -   If the value in the
#'     [`update_health_check`][route53_update_health_check] request matches
#'     the value of `HealthCheckVersion` in the health check, Route 53
#'     updates the health check with the new settings.
#' 
#' -   If the value of `HealthCheckVersion` in the health check is greater,
#'     the health check was changed after you got the version number. Route
#'     53 does not update the health check, and it returns a
#'     `HealthCheckVersionMismatch` error.
#' @param IPAddress The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route
#' 53 to perform health checks on. If you don't specify a value for
#' `IPAddress`, Route 53 sends a DNS request to resolve the domain name
#' that you specify in `FullyQualifiedDomainName` at the interval that you
#' specify in `RequestInterval`. Using an IP address that is returned by
#' DNS, Route 53 then checks the health of the endpoint.
#' 
#' Use one of the following formats for the value of `IPAddress`:
#' 
#' -   **IPv4 address**: four values between 0 and 255, separated by
#'     periods (.), for example, `192.0.2.44`.
#' 
#' -   **IPv6 address**: eight groups of four hexadecimal values, separated
#'     by colons (:), for example,
#'     `2001:0db8:85a3:0000:0000:abcd:0001:2345`. You can also shorten IPv6
#'     addresses as described in RFC 5952, for example,
#'     `2001:db8:85a3::abcd:1:2345`.
#' 
#' If the endpoint is an EC2 instance, we recommend that you create an
#' Elastic IP address, associate it with your EC2 instance, and specify the
#' Elastic IP address for `IPAddress`. This ensures that the IP address of
#' your instance never changes. For more information, see the applicable
#' documentation:
#' 
#' -   Linux: [Elastic IP Addresses
#'     (EIP)](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
#'     in the *Amazon EC2 User Guide for Linux Instances*
#' 
#' -   Windows: [Elastic IP Addresses
#'     (EIP)](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-ip-addresses-eip.html)
#'     in the *Amazon EC2 User Guide for Windows Instances*
#' 
#' If a health check already has a value for `IPAddress`, you can change
#' the value. However, you can't update an existing health check to add or
#' remove the value of `IPAddress`.
#' 
#' For more information, see
#' [FullyQualifiedDomainName](https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName).
#' 
#' Constraints: Route 53 can't check the health of endpoints for which the
#' IP address is in local, private, non-routable, or multicast ranges. For
#' more information about IP addresses for which you can't create health
#' checks, see the following documents:
#' 
#' -   [RFC 5735, Special Use IPv4
#'     Addresses](https://www.rfc-editor.org/rfc/rfc5735)
#' 
#' -   [RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address
#'     Space](https://www.rfc-editor.org/rfc/rfc6598)
#' 
#' -   RFC 5156, Special-Use IPv6 Addresses
#' @param Port The port on the endpoint that you want Amazon Route 53 to perform health
#' checks on.
#' 
#' Don't specify a value for `Port` when you specify a value for `Type` of
#' `CLOUDWATCH_METRIC` or `CALCULATED`.
#' @param ResourcePath The path that you want Amazon Route 53 to request when performing health
#' checks. The path can be any value for which your endpoint will return an
#' HTTP status code of 2xx or 3xx when the endpoint is healthy, for example
#' the file /docs/route53-health-check.html. You can also include query
#' string parameters, for example, `/welcome.html?language=jp&login=y`.
#' 
#' Specify this value only if you want to change it.
#' @param FullyQualifiedDomainName Amazon Route 53 behavior depends on whether you specify a value for
#' `IPAddress`.
#' 
#' If a health check already has a value for `IPAddress`, you can change
#' the value. However, you can't update an existing health check to add or
#' remove the value of `IPAddress`.
#' 
#' **If you specify a value for** `IPAddress`:
#' 
#' Route 53 sends health check requests to the specified IPv4 or IPv6
#' address and passes the value of `FullyQualifiedDomainName` in the `Host`
#' header for all health checks except TCP health checks. This is typically
#' the fully qualified DNS name of the endpoint on which you want Route 53
#' to perform health checks.
#' 
#' When Route 53 checks the health of an endpoint, here is how it
#' constructs the `Host` header:
#' 
#' -   If you specify a value of `80` for `Port` and `HTTP` or
#'     `HTTP_STR_MATCH` for `Type`, Route 53 passes the value of
#'     `FullyQualifiedDomainName` to the endpoint in the `Host` header.
#' 
#' -   If you specify a value of `443` for `Port` and `HTTPS` or
#'     `HTTPS_STR_MATCH` for `Type`, Route 53 passes the value of
#'     `FullyQualifiedDomainName` to the endpoint in the `Host` header.
#' 
#' -   If you specify another value for `Port` and any value except `TCP`
#'     for `Type`, Route 53 passes *FullyQualifiedDomainName:Port* to the
#'     endpoint in the `Host` header.
#' 
#' If you don't specify a value for `FullyQualifiedDomainName`, Route 53
#' substitutes the value of `IPAddress` in the `Host` header in each of the
#' above cases.
#' 
#' **If you don't specify a value for** `IPAddress`:
#' 
#' If you don't specify a value for `IPAddress`, Route 53 sends a DNS
#' request to the domain that you specify in `FullyQualifiedDomainName` at
#' the interval you specify in `RequestInterval`. Using an IPv4 address
#' that is returned by DNS, Route 53 then checks the health of the
#' endpoint.
#' 
#' If you don't specify a value for `IPAddress`, Route 53 uses only IPv4 to
#' send health checks to the endpoint. If there's no resource record set
#' with a type of A for the name that you specify for
#' `FullyQualifiedDomainName`, the health check fails with a "DNS
#' resolution failed" error.
#' 
#' If you want to check the health of weighted, latency, or failover
#' resource record sets and you choose to specify the endpoint only by
#' `FullyQualifiedDomainName`, we recommend that you create a separate
#' health check for each endpoint. For example, create a health check for
#' each HTTP server that is serving content for www.example.com. For the
#' value of `FullyQualifiedDomainName`, specify the domain name of the
#' server (such as `us-east-2-www.example.com`), not the name of the
#' resource record sets (www.example.com).
#' 
#' In this configuration, if the value of `FullyQualifiedDomainName`
#' matches the name of the resource record sets and you then associate the
#' health check with those resource record sets, health check results will
#' be unpredictable.
#' 
#' In addition, if the value of `Type` is `HTTP`, `HTTPS`,
#' `HTTP_STR_MATCH`, or `HTTPS_STR_MATCH`, Route 53 passes the value of
#' `FullyQualifiedDomainName` in the `Host` header, as it does when you
#' specify a value for `IPAddress`. If the value of `Type` is `TCP`, Route
#' 53 doesn't pass a `Host` header.
#' @param SearchString If the value of `Type` is `HTTP_STR_MATCH` or `HTTPS_STR_MATCH`, the
#' string that you want Amazon Route 53 to search for in the response body
#' from the specified resource. If the string appears in the response body,
#' Route 53 considers the resource healthy. (You can't change the value of
#' `Type` when you update a health check.)
#' @param FailureThreshold The number of consecutive health checks that an endpoint must pass or
#' fail for Amazon Route 53 to change the current status of the endpoint
#' from unhealthy to healthy or vice versa. For more information, see [How
#' Amazon Route 53 Determines Whether an Endpoint Is
#' Healthy](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' If you don't specify a value for `FailureThreshold`, the default value
#' is three health checks.
#' @param Inverted Specify whether you want Amazon Route 53 to invert the status of a
#' health check, for example, to consider a health check unhealthy when it
#' otherwise would be considered healthy.
#' @param Disabled Stops Route 53 from performing health checks. When you disable a health
#' check, here's what happens:
#' 
#' -   **Health checks that check the health of endpoints:** Route 53 stops
#'     submitting requests to your application, server, or other resource.
#' 
#' -   **Calculated health checks:** Route 53 stops aggregating the status
#'     of the referenced health checks.
#' 
#' -   **Health checks that monitor CloudWatch alarms:** Route 53 stops
#'     monitoring the corresponding CloudWatch metrics.
#' 
#' After you disable a health check, Route 53 considers the status of the
#' health check to always be healthy. If you configured DNS failover, Route
#' 53 continues to route traffic to the corresponding resources. If you
#' want to stop routing traffic to a resource, change the value of
#' [Inverted](https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted).
#' 
#' Charges for a health check still apply when the health check is
#' disabled. For more information, see [Amazon Route 53
#' Pricing](https://aws.amazon.com/route53/pricing/).
#' @param HealthThreshold The number of child health checks that are associated with a
#' `CALCULATED` health that Amazon Route 53 must consider healthy for the
#' `CALCULATED` health check to be considered healthy. To specify the child
#' health checks that you want to associate with a `CALCULATED` health
#' check, use the `ChildHealthChecks` and `ChildHealthCheck` elements.
#' 
#' Note the following:
#' 
#' -   If you specify a number greater than the number of child health
#'     checks, Route 53 always considers this health check to be unhealthy.
#' 
#' -   If you specify `0`, Route 53 always considers this health check to
#'     be healthy.
#' @param ChildHealthChecks A complex type that contains one `ChildHealthCheck` element for each
#' health check that you want to associate with a `CALCULATED` health
#' check.
#' @param EnableSNI Specify whether you want Amazon Route 53 to send the value of
#' `FullyQualifiedDomainName` to the endpoint in the `client_hello` message
#' during `TLS` negotiation. This allows the endpoint to respond to `HTTPS`
#' health check requests with the applicable SSL/TLS certificate.
#' 
#' Some endpoints require that HTTPS requests include the host name in the
#' `client_hello` message. If you don't enable SNI, the status of the
#' health check will be SSL alert `handshake_failure`. A health check can
#' also have that status for other reasons. If SNI is enabled and you're
#' still getting the error, check the SSL/TLS configuration on your
#' endpoint and confirm that your certificate is valid.
#' 
#' The SSL/TLS certificate on your endpoint includes a domain name in the
#' `Common Name` field and possibly several more in the
#' `Subject Alternative Names` field. One of the domain names in the
#' certificate should match the value that you specify for
#' `FullyQualifiedDomainName`. If the endpoint responds to the
#' `client_hello` message with a certificate that does not include the
#' domain name that you specified in `FullyQualifiedDomainName`, a health
#' checker will retry the handshake. In the second attempt, the health
#' checker will omit `FullyQualifiedDomainName` from the `client_hello`
#' message.
#' @param Regions A complex type that contains one `Region` element for each region that
#' you want Amazon Route 53 health checkers to check the specified endpoint
#' from.
#' @param AlarmIdentifier A complex type that identifies the CloudWatch alarm that you want Amazon
#' Route 53 health checkers to use to determine whether the specified
#' health check is healthy.
#' @param InsufficientDataHealthStatus When CloudWatch has insufficient data about the metric to determine the
#' alarm state, the status that you want Amazon Route 53 to assign to the
#' health check:
#' 
#' -   `Healthy`: Route 53 considers the health check to be healthy.
#' 
#' -   `Unhealthy`: Route 53 considers the health check to be unhealthy.
#' 
#' -   `LastKnownStatus`: By default, Route 53 uses the status of the
#'     health check from the last time CloudWatch had sufficient data to
#'     determine the alarm state. For new health checks that have no last
#'     known status, the status for the health check is healthy.
#' @param ResetElements A complex type that contains one `ResettableElementName` element for
#' each element that you want to reset to the default value. Valid values
#' for `ResettableElementName` include the following:
#' 
#' -   `ChildHealthChecks`: Amazon Route 53 resets
#'     [ChildHealthChecks](https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ChildHealthChecks)
#'     to null.
#' 
#' -   `FullyQualifiedDomainName`: Route 53 resets
#'     [FullyQualifiedDomainName](https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName).
#'     to null.
#' 
#' -   `Regions`: Route 53 resets the
#'     [Regions](https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions)
#'     list to the default set of regions.
#' 
#' -   `ResourcePath`: Route 53 resets
#'     [ResourcePath](https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ResourcePath)
#'     to null.
#'
#' @keywords internal
#'
#' @rdname route53_update_health_check
route53_update_health_check <- function(HealthCheckId, HealthCheckVersion = NULL, IPAddress = NULL, Port = NULL, ResourcePath = NULL, FullyQualifiedDomainName = NULL, SearchString = NULL, FailureThreshold = NULL, Inverted = NULL, Disabled = NULL, HealthThreshold = NULL, ChildHealthChecks = NULL, EnableSNI = NULL, Regions = NULL, AlarmIdentifier = NULL, InsufficientDataHealthStatus = NULL, ResetElements = NULL) {
  op <- new_operation(
    name = "UpdateHealthCheck",
    http_method = "POST",
    http_path = "/2013-04-01/healthcheck/{HealthCheckId}",
    paginator = list()
  )
  input <- .route53$update_health_check_input(HealthCheckId = HealthCheckId, HealthCheckVersion = HealthCheckVersion, IPAddress = IPAddress, Port = Port, ResourcePath = ResourcePath, FullyQualifiedDomainName = FullyQualifiedDomainName, SearchString = SearchString, FailureThreshold = FailureThreshold, Inverted = Inverted, Disabled = Disabled, HealthThreshold = HealthThreshold, ChildHealthChecks = ChildHealthChecks, EnableSNI = EnableSNI, Regions = Regions, AlarmIdentifier = AlarmIdentifier, InsufficientDataHealthStatus = InsufficientDataHealthStatus, ResetElements = ResetElements)
  output <- .route53$update_health_check_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$update_health_check <- route53_update_health_check

#' Updates the comment for a specified hosted zone
#'
#' @description
#' Updates the comment for a specified hosted zone.
#'
#' See [https://paws-r.github.io/docs/route53/update_hosted_zone_comment.html](https://paws-r.github.io/docs/route53/update_hosted_zone_comment.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID for the hosted zone that you want to update the comment for.
#' @param Comment The new comment for the hosted zone. If you don't specify a value for
#' `Comment`, Amazon Route 53 deletes the existing value of the `Comment`
#' element, if any.
#'
#' @keywords internal
#'
#' @rdname route53_update_hosted_zone_comment
route53_update_hosted_zone_comment <- function(Id, Comment = NULL) {
  op <- new_operation(
    name = "UpdateHostedZoneComment",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}",
    paginator = list()
  )
  input <- .route53$update_hosted_zone_comment_input(Id = Id, Comment = Comment)
  output <- .route53$update_hosted_zone_comment_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$update_hosted_zone_comment <- route53_update_hosted_zone_comment

#' Updates the comment for a specified traffic policy version
#'
#' @description
#' Updates the comment for a specified traffic policy version.
#'
#' See [https://paws-r.github.io/docs/route53/update_traffic_policy_comment.html](https://paws-r.github.io/docs/route53/update_traffic_policy_comment.html) for full documentation.
#'
#' @param Id &#91;required&#93; The value of `Id` for the traffic policy that you want to update the
#' comment for.
#' @param Version &#91;required&#93; The value of `Version` for the traffic policy that you want to update
#' the comment for.
#' @param Comment &#91;required&#93; The new comment for the specified traffic policy and version.
#'
#' @keywords internal
#'
#' @rdname route53_update_traffic_policy_comment
route53_update_traffic_policy_comment <- function(Id, Version, Comment) {
  op <- new_operation(
    name = "UpdateTrafficPolicyComment",
    http_method = "POST",
    http_path = "/2013-04-01/trafficpolicy/{Id}/{Version}",
    paginator = list()
  )
  input <- .route53$update_traffic_policy_comment_input(Id = Id, Version = Version, Comment = Comment)
  output <- .route53$update_traffic_policy_comment_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$update_traffic_policy_comment <- route53_update_traffic_policy_comment

#' Updates the resource record sets in a specified hosted zone that were
#' created based on the settings in a specified traffic policy version
#'
#' @description
#' Updates the resource record sets in a specified hosted zone that were created based on the settings in a specified traffic policy version.
#'
#' See [https://paws-r.github.io/docs/route53/update_traffic_policy_instance.html](https://paws-r.github.io/docs/route53/update_traffic_policy_instance.html) for full documentation.
#'
#' @param Id &#91;required&#93; The ID of the traffic policy instance that you want to update.
#' @param TTL &#91;required&#93; The TTL that you want Amazon Route 53 to assign to all of the updated
#' resource record sets.
#' @param TrafficPolicyId &#91;required&#93; The ID of the traffic policy that you want Amazon Route 53 to use to
#' update resource record sets for the specified traffic policy instance.
#' @param TrafficPolicyVersion &#91;required&#93; The version of the traffic policy that you want Amazon Route 53 to use
#' to update resource record sets for the specified traffic policy
#' instance.
#'
#' @keywords internal
#'
#' @rdname route53_update_traffic_policy_instance
route53_update_traffic_policy_instance <- function(Id, TTL, TrafficPolicyId, TrafficPolicyVersion) {
  op <- new_operation(
    name = "UpdateTrafficPolicyInstance",
    http_method = "POST",
    http_path = "/2013-04-01/trafficpolicyinstance/{Id}",
    paginator = list()
  )
  input <- .route53$update_traffic_policy_instance_input(Id = Id, TTL = TTL, TrafficPolicyId = TrafficPolicyId, TrafficPolicyVersion = TrafficPolicyVersion)
  output <- .route53$update_traffic_policy_instance_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$update_traffic_policy_instance <- route53_update_traffic_policy_instance
