% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_create_public_virtual_interface}
\alias{directconnect_create_public_virtual_interface}
\title{Creates a public virtual interface}
\usage{
directconnect_create_public_virtual_interface(connectionId,
  newPublicVirtualInterface)
}
\arguments{
\item{connectionId}{[required] The ID of the connection.}

\item{newPublicVirtualInterface}{[required] Information about the public virtual interface.}
}
\description{
Creates a public virtual interface. A virtual interface is the VLAN that
transports AWS Direct Connect traffic. A public virtual interface
supports sending traffic to public services of AWS such as Amazon S3.
}
\details{
When creating an IPv6 public virtual interface (\code{addressFamily} is
\code{ipv6}), leave the \code{customer} and \code{amazon} address fields blank to use
auto-assigned IPv6 space. Custom IPv6 addresses are not supported.
}
\section{Request syntax}{
\preformatted{svc$create_public_virtual_interface(
  connectionId = "string",
  newPublicVirtualInterface = list(
    virtualInterfaceName = "string",
    vlan = 123,
    asn = 123,
    authKey = "string",
    amazonAddress = "string",
    customerAddress = "string",
    addressFamily = "ipv4"|"ipv6",
    routeFilterPrefixes = list(
      list(
        cidr = "string"
      )
    ),
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    )
  )
)
}
}

\keyword{internal}
