% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_update_endpoint_group}
\alias{globalaccelerator_update_endpoint_group}
\title{Update an endpoint group}
\usage{
globalaccelerator_update_endpoint_group(EndpointGroupArn,
  EndpointConfigurations, TrafficDialPercentage, HealthCheckPort,
  HealthCheckProtocol, HealthCheckPath, HealthCheckIntervalSeconds,
  ThresholdCount)
}
\arguments{
\item{EndpointGroupArn}{[required] The Amazon Resource Name (ARN) of the endpoint group.}

\item{EndpointConfigurations}{The list of endpoint objects.}

\item{TrafficDialPercentage}{The percentage of traffic to send to an AWS Region. Additional traffic
is distributed to other endpoint groups for this listener.

Use this action to increase (dial up) or decrease (dial down) traffic to
a specific Region. The percentage is applied to the traffic that would
otherwise have been routed to the Region based on optimal routing.

The default value is 100.}

\item{HealthCheckPort}{The port that AWS Global Accelerator uses to check the health of
endpoints that are part of this endpoint group. The default port is the
listener port that this endpoint group is associated with. If the
listener port is a list of ports, Global Accelerator uses the first port
in the list.}

\item{HealthCheckProtocol}{The protocol that AWS Global Accelerator uses to check the health of
endpoints that are part of this endpoint group. The default value is
TCP.}

\item{HealthCheckPath}{If the protocol is HTTP/S, then this specifies the path that is the
destination for health check targets. The default value is slash (/).}

\item{HealthCheckIntervalSeconds}{The time---10 seconds or 30 seconds---between each health check for an
endpoint. The default value is 30.}

\item{ThresholdCount}{The number of consecutive health checks required to set the state of a
healthy endpoint to unhealthy, or to set an unhealthy endpoint to
healthy. The default value is 3.}
}
\description{
Update an endpoint group. To see an AWS CLI example of updating an
endpoint group, scroll down to \strong{Example}.
}
\section{Request syntax}{
\preformatted{svc$update_endpoint_group(
  EndpointGroupArn = "string",
  EndpointConfigurations = list(
    list(
      EndpointId = "string",
      Weight = 123,
      ClientIPPreservationEnabled = TRUE|FALSE
    )
  ),
  TrafficDialPercentage = 123.0,
  HealthCheckPort = 123,
  HealthCheckProtocol = "TCP"|"HTTP"|"HTTPS",
  HealthCheckPath = "string",
  HealthCheckIntervalSeconds = 123,
  ThresholdCount = 123
)
}
}

\keyword{internal}
