% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_create_cloud_front_origin_access_identity}
\alias{cloudfront_create_cloud_front_origin_access_identity}
\title{Creates a new origin access identity}
\usage{
cloudfront_create_cloud_front_origin_access_identity(
  CloudFrontOriginAccessIdentityConfig)
}
\arguments{
\item{CloudFrontOriginAccessIdentityConfig}{[required] The current configuration information for the identity.}
}
\description{
Creates a new origin access identity. If you\'re using Amazon S3 for
your origin, you can use an origin access identity to require users to
access your content using a CloudFront URL instead of the Amazon S3 URL.
For more information about how to use origin access identities, see
\href{https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html}{Serving Private Content through CloudFront}
in the \emph{Amazon CloudFront Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_cloud_front_origin_access_identity(
  CloudFrontOriginAccessIdentityConfig = list(
    CallerReference = "string",
    Comment = "string"
  )
)
}
}

\keyword{internal}
