% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_associate_vpc_with_hosted_zone}
\alias{route53_associate_vpc_with_hosted_zone}
\title{Associates an Amazon VPC with a private hosted zone}
\usage{
route53_associate_vpc_with_hosted_zone(HostedZoneId, VPC, Comment)
}
\arguments{
\item{HostedZoneId}{[required] The ID of the private hosted zone that you want to associate an Amazon
VPC with.

Note that you can\'t associate a VPC with a hosted zone that doesn\'t
have an existing VPC association.}

\item{VPC}{[required] A complex type that contains information about the VPC that you want to
associate with a private hosted zone.}

\item{Comment}{\emph{Optional:} A comment about the association request.}
}
\description{
Associates an Amazon VPC with a private hosted zone.
}
\details{
To perform the association, the VPC and the private hosted zone must
already exist. You can\'t convert a public hosted zone into a private
hosted zone.

If you want to associate a VPC that was created by using one AWS account
with a private hosted zone that was created by using a different
account, the AWS account that created the private hosted zone must first
submit a \code{CreateVPCAssociationAuthorization} request. Then the account
that created the VPC must submit an \code{AssociateVPCWithHostedZone}
request.
}
\section{Request syntax}{
\preformatted{svc$associate_vpc_with_hosted_zone(
  HostedZoneId = "string",
  VPC = list(
    VPCRegion = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ap-east-1"|"me-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-south-1"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"ca-central-1"|"cn-north-1",
    VPCId = "string"
  ),
  Comment = "string"
)
}
}

\examples{
# The following example associates the VPC with ID vpc-1a2b3c4d with the
# hosted zone with ID Z3M3LMPEXAMPLE.
\donttest{svc$associate_vpc_with_hosted_zone(
  Comment = "",
  HostedZoneId = "Z3M3LMPEXAMPLE",
  VPC = list(
    VPCId = "vpc-1a2b3c4d",
    VPCRegion = "us-east-2"
  )
)}

}
\keyword{internal}
