% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_describe_load_balancer_attributes}
\alias{elbv2_describe_load_balancer_attributes}
\title{Describes the attributes for the specified Application Load Balancer or
Network Load Balancer}
\usage{
elbv2_describe_load_balancer_attributes(LoadBalancerArn)
}
\arguments{
\item{LoadBalancerArn}{[required] The Amazon Resource Name (ARN) of the load balancer.}
}
\description{
Describes the attributes for the specified Application Load Balancer or
Network Load Balancer.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes}{Load Balancer Attributes}
in the \emph{Application Load Balancers Guide} or \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes}{Load Balancer Attributes}
in the \emph{Network Load Balancers Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_load_balancer_attributes(
  LoadBalancerArn = "string"
)
}
}

\examples{
# This example describes the attributes of the specified load balancer.
\donttest{svc$describe_load_balancer_attributes(
  LoadBalancerArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my..."
)}

}
\keyword{internal}
