% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_list_resolver_rules}
\alias{route53resolver_list_resolver_rules}
\title{Lists the Resolver rules that were created using the current AWS account}
\usage{
route53resolver_list_resolver_rules(MaxResults, NextToken, Filters)
}
\arguments{
\item{MaxResults}{The maximum number of Resolver rules that you want to return in the
response to a
\code{\link[=route53resolver_list_resolver_rules]{list_resolver_rules}} request. If
you don't specify a value for \code{MaxResults}, Resolver returns up to 100
Resolver rules.}

\item{NextToken}{For the first
\code{\link[=route53resolver_list_resolver_rules]{list_resolver_rules}} request,
omit this value.

If you have more than \code{MaxResults} Resolver rules, you can submit
another \code{\link[=route53resolver_list_resolver_rules]{list_resolver_rules}}
request to get the next group of Resolver rules. In the next request,
specify the value of \code{NextToken} from the previous response.}

\item{Filters}{An optional specification to return a subset of Resolver rules, such as
all Resolver rules that are associated with the same Resolver endpoint.

If you submit a second or subsequent
\code{\link[=route53resolver_list_resolver_rules]{list_resolver_rules}} request and
specify the \code{NextToken} parameter, you must use the same values for
\code{Filters}, if any, as in the previous request.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  MaxResults = 123,
  ResolverRules = list(
    list(
      Id = "string",
      CreatorRequestId = "string",
      Arn = "string",
      DomainName = "string",
      Status = "COMPLETE"|"DELETING"|"UPDATING"|"FAILED",
      StatusMessage = "string",
      RuleType = "FORWARD"|"SYSTEM"|"RECURSIVE",
      Name = "string",
      TargetIps = list(
        list(
          Ip = "string",
          Port = 123
        )
      ),
      ResolverEndpointId = "string",
      OwnerId = "string",
      ShareStatus = "NOT_SHARED"|"SHARED_WITH_ME"|"SHARED_BY_ME",
      CreationTime = "string",
      ModificationTime = "string"
    )
  )
)
}
}
\description{
Lists the Resolver rules that were created using the current AWS
account.
}
\section{Request syntax}{
\preformatted{svc$list_resolver_rules(
  MaxResults = 123,
  NextToken = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
