% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_list_endpoint_groups}
\alias{globalaccelerator_list_endpoint_groups}
\title{List the endpoint groups that are associated with a listener}
\usage{
globalaccelerator_list_endpoint_groups(ListenerArn, MaxResults,
  NextToken)
}
\arguments{
\item{ListenerArn}{[required] The Amazon Resource Name (ARN) of the listener.}

\item{MaxResults}{The number of endpoint group objects that you want to return with this
call. The default value is 10.}

\item{NextToken}{The token for the next set of results. You receive this token from a
previous call.}
}
\value{
A list with the following syntax:\preformatted{list(
  EndpointGroups = list(
    list(
      EndpointGroupArn = "string",
      EndpointGroupRegion = "string",
      EndpointDescriptions = list(
        list(
          EndpointId = "string",
          Weight = 123,
          HealthState = "INITIAL"|"HEALTHY"|"UNHEALTHY",
          HealthReason = "string",
          ClientIPPreservationEnabled = TRUE|FALSE
        )
      ),
      TrafficDialPercentage = 123.0,
      HealthCheckPort = 123,
      HealthCheckProtocol = "TCP"|"HTTP"|"HTTPS",
      HealthCheckPath = "string",
      HealthCheckIntervalSeconds = 123,
      ThresholdCount = 123,
      PortOverrides = list(
        list(
          ListenerPort = 123,
          EndpointPort = 123
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
List the endpoint groups that are associated with a listener.
}
\section{Request syntax}{
\preformatted{svc$list_endpoint_groups(
  ListenerArn = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
