% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_get_usage_plan_keys}
\alias{apigateway_get_usage_plan_keys}
\title{Gets all the usage plan keys representing the API keys added to a
specified usage plan}
\usage{
apigateway_get_usage_plan_keys(usagePlanId, position, limit, nameQuery)
}
\arguments{
\item{usagePlanId}{[required] [Required] The Id of the UsagePlan resource representing the usage
plan containing the to-be-retrieved UsagePlanKey resource representing a
plan customer.}

\item{position}{The current pagination position in the paged result set.}

\item{limit}{The maximum number of returned results per page. The default value is 25
and the maximum value is 500.}

\item{nameQuery}{A query parameter specifying the name of the to-be-returned usage plan
keys.}
}
\value{
A list with the following syntax:\preformatted{list(
  position = "string",
  items = list(
    list(
      id = "string",
      type = "string",
      value = "string",
      name = "string"
    )
  )
)
}
}
\description{
Gets all the usage plan keys representing the API keys added to a
specified usage plan.
}
\section{Request syntax}{
\preformatted{svc$get_usage_plan_keys(
  usagePlanId = "string",
  position = "string",
  limit = 123,
  nameQuery = "string"
)
}
}

\keyword{internal}
