% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_untag_resource}
\alias{servicediscovery_untag_resource}
\title{Removes one or more tags from the specified resource}
\usage{
servicediscovery_untag_resource(ResourceARN, TagKeys)
}
\arguments{
\item{ResourceARN}{[required] The Amazon Resource Name (ARN) of the resource that you want to retrieve
tags for.}

\item{TagKeys}{[required] The tag keys to remove from the specified resource.}
}
\value{
An empty list.
}
\description{
Removes one or more tags from the specified resource.
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  ResourceARN = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This example removes the "Department" and "Project" tags from a
# resource.
svc$untag_resource(
  ResourceARN = "arn:aws:servicediscovery:us-east-1:123456789012:namespace/...",
  TagKeys = list(
    "Project",
    "Department"
  )
)
}

}
\keyword{internal}
