% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_get_instance}
\alias{servicediscovery_get_instance}
\title{Gets information about a specified instance}
\usage{
servicediscovery_get_instance(ServiceId, InstanceId)
}
\arguments{
\item{ServiceId}{[required] The ID of the service that the instance is associated with.}

\item{InstanceId}{[required] The ID of the instance that you want to get information about.}
}
\value{
A list with the following syntax:\preformatted{list(
  Instance = list(
    Id = "string",
    CreatorRequestId = "string",
    Attributes = list(
      "string"
    )
  )
)
}
}
\description{
Gets information about a specified instance.
}
\section{Request syntax}{
\preformatted{svc$get_instance(
  ServiceId = "string",
  InstanceId = "string"
)
}
}

\examples{
\dontrun{
# This example gets information about a specified instance.
svc$get_instance(
  InstanceId = "i-abcd1234",
  ServiceId = "srv-e4anhexample0004"
)
}

}
\keyword{internal}
