% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_remove_tags}
\alias{elb_remove_tags}
\title{Removes one or more tags from the specified load balancer}
\usage{
elb_remove_tags(LoadBalancerNames, Tags)
}
\arguments{
\item{LoadBalancerNames}{[required] The name of the load balancer. You can specify a maximum of one load
balancer name.}

\item{Tags}{[required] The list of tag keys to remove.}
}
\value{
An empty list.
}
\description{
Removes one or more tags from the specified load balancer.
}
\section{Request syntax}{
\preformatted{svc$remove_tags(
  LoadBalancerNames = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# This example removes the specified tag from the specified load balancer.
svc$remove_tags(
  LoadBalancerNames = list(
    "my-load-balancer"
  ),
  Tags = list(
    list(
      Key = "project"
    )
  )
)
}

}
\keyword{internal}
