% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_delete_lag}
\alias{directconnect_delete_lag}
\title{Deletes the specified link aggregation group (LAG)}
\usage{
directconnect_delete_lag(lagId)
}
\arguments{
\item{lagId}{[required] The ID of the LAG.}
}
\value{
A list with the following syntax:\preformatted{list(
  connectionsBandwidth = "string",
  numberOfConnections = 123,
  lagId = "string",
  ownerAccount = "string",
  lagName = "string",
  lagState = "requested"|"pending"|"available"|"down"|"deleting"|"deleted"|"unknown",
  location = "string",
  region = "string",
  minimumLinks = 123,
  awsDevice = "string",
  awsDeviceV2 = "string",
  connections = list(
    list(
      ownerAccount = "string",
      connectionId = "string",
      connectionName = "string",
      connectionState = "ordering"|"requested"|"pending"|"available"|"down"|"deleting"|"deleted"|"rejected"|"unknown",
      region = "string",
      location = "string",
      bandwidth = "string",
      vlan = 123,
      partnerName = "string",
      loaIssueTime = as.POSIXct(
        "2015-01-01"
      ),
      lagId = "string",
      awsDevice = "string",
      jumboFrameCapable = TRUE|FALSE,
      awsDeviceV2 = "string",
      hasLogicalRedundancy = "unknown"|"yes"|"no",
      tags = list(
        list(
          key = "string",
          value = "string"
        )
      ),
      providerName = "string"
    )
  ),
  allowsHostedConnections = TRUE|FALSE,
  jumboFrameCapable = TRUE|FALSE,
  hasLogicalRedundancy = "unknown"|"yes"|"no",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  providerName = "string"
)
}
}
\description{
Deletes the specified link aggregation group (LAG). You cannot delete a
LAG if it has active virtual interfaces or hosted connections.
}
\section{Request syntax}{
\preformatted{svc$delete_lag(
  lagId = "string"
)
}
}

\keyword{internal}
