% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_list_virtual_services}
\alias{appmesh_list_virtual_services}
\title{Returns a list of existing virtual services in a service mesh}
\usage{
appmesh_list_virtual_services(limit, meshName, meshOwner, nextToken)
}
\arguments{
\item{limit}{The maximum number of results returned by
\code{\link[=appmesh_list_virtual_services]{list_virtual_services}} in paginated
output. When you use this parameter,
\code{\link[=appmesh_list_virtual_services]{list_virtual_services}} returns only
\code{limit} results in a single page along with a \code{nextToken} response
element. You can see the remaining results of the initial request by
sending another \code{\link[=appmesh_list_virtual_services]{list_virtual_services}}
request with the returned \code{nextToken} value. This value can be between 1
and 100. If you don't use this parameter,
\code{\link[=appmesh_list_virtual_services]{list_virtual_services}} returns up to
100 results and a \code{nextToken} value if applicable.}

\item{meshName}{[required] The name of the service mesh to list virtual services in.}

\item{meshOwner}{The AWS IAM account ID of the service mesh owner. If the account ID is
not your own, then it's the ID of the account that shared the mesh with
your account. For more information about mesh sharing, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{\link[=appmesh_list_virtual_services]{list_virtual_services}} request where
\code{limit} was used and the results exceeded the value of that parameter.
Pagination continues from the end of the previous results that returned
the \code{nextToken} value.}
}
\value{
A list with the following syntax:\preformatted{list(
  nextToken = "string",
  virtualServices = list(
    list(
      arn = "string",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdatedAt = as.POSIXct(
        "2015-01-01"
      ),
      meshName = "string",
      meshOwner = "string",
      resourceOwner = "string",
      version = 123,
      virtualServiceName = "string"
    )
  )
)
}
}
\description{
Returns a list of existing virtual services in a service mesh.
}
\section{Request syntax}{
\preformatted{svc$list_virtual_services(
  limit = 123,
  meshName = "string",
  meshOwner = "string",
  nextToken = "string"
)
}
}

\keyword{internal}
