% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_create_vpc_link}
\alias{apigatewayv2_create_vpc_link}
\title{Creates a VPC link}
\usage{
apigatewayv2_create_vpc_link(Name, SecurityGroupIds, SubnetIds, Tags)
}
\arguments{
\item{Name}{[required] The name of the VPC link.}

\item{SecurityGroupIds}{A list of security group IDs for the VPC link.}

\item{SubnetIds}{[required] A list of subnet IDs to include in the VPC link.}

\item{Tags}{A list of tags.}
}
\value{
A list with the following syntax:\preformatted{list(
  CreatedDate = as.POSIXct(
    "2015-01-01"
  ),
  Name = "string",
  SecurityGroupIds = list(
    "string"
  ),
  SubnetIds = list(
    "string"
  ),
  Tags = list(
    "string"
  ),
  VpcLinkId = "string",
  VpcLinkStatus = "PENDING"|"AVAILABLE"|"DELETING"|"FAILED"|"INACTIVE",
  VpcLinkStatusMessage = "string",
  VpcLinkVersion = "V2"
)
}
}
\description{
Creates a VPC link.
}
\section{Request syntax}{
\preformatted{svc$create_vpc_link(
  Name = "string",
  SecurityGroupIds = list(
    "string"
  ),
  SubnetIds = list(
    "string"
  ),
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
