% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_untag_resource}
\alias{route53resolver_untag_resource}
\title{Removes one or more tags from a specified resource}
\usage{
route53resolver_untag_resource(ResourceArn, TagKeys)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) for the resource that you want to remove
tags from. To get the ARN for a resource, use the applicable \code{Get} or
\code{List} command:
\itemize{
\item \href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverEndpoint.html}{GetResolverEndpoint}
\item \href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRule.html}{GetResolverRule}
\item \href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_GetResolverRuleAssociation.html}{GetResolverRuleAssociation}
\item \href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverEndpoints.html}{ListResolverEndpoints}
\item \href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRuleAssociations.html}{ListResolverRuleAssociations}
\item \href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_route53resolver_ListResolverRules.html}{ListResolverRules}
}}

\item{TagKeys}{[required] The tags that you want to remove to the specified resource.}
}
\description{
Removes one or more tags from a specified resource.
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  ResourceArn = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
