% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_list_resolver_endpoint_ip_addresses}
\alias{route53resolver_list_resolver_endpoint_ip_addresses}
\title{Gets the IP addresses for a specified Resolver endpoint}
\usage{
route53resolver_list_resolver_endpoint_ip_addresses(ResolverEndpointId,
  MaxResults, NextToken)
}
\arguments{
\item{ResolverEndpointId}{[required] The ID of the Resolver endpoint that you want to get IP addresses for.}

\item{MaxResults}{The maximum number of IP addresses that you want to return in the
response to a \code{ListResolverEndpointIpAddresses} request. If you don't
specify a value for \code{MaxResults}, Resolver returns up to 100 IP
addresses.}

\item{NextToken}{For the first \code{ListResolverEndpointIpAddresses} request, omit this
value.

If the specified Resolver endpoint has more than \code{MaxResults} IP
addresses, you can submit another \code{ListResolverEndpointIpAddresses}
request to get the next group of IP addresses. In the next request,
specify the value of \code{NextToken} from the previous response.}
}
\description{
Gets the IP addresses for a specified Resolver endpoint.
}
\section{Request syntax}{
\preformatted{svc$list_resolver_endpoint_ip_addresses(
  ResolverEndpointId = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
