% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_create_custom_routing_listener}
\alias{globalaccelerator_create_custom_routing_listener}
\title{Create a listener to process inbound connections from clients to a
custom routing accelerator}
\usage{
globalaccelerator_create_custom_routing_listener(AcceleratorArn,
  PortRanges, IdempotencyToken)
}
\arguments{
\item{AcceleratorArn}{[required] The Amazon Resource Name (ARN) of the accelerator for a custom routing
listener.}

\item{PortRanges}{[required] The port range to support for connections from clients to your
accelerator.

Separately, you set port ranges for endpoints. For more information, see
\href{https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html}{About endpoints for custom routing accelerators}.}

\item{IdempotencyToken}{[required] A unique, case-sensitive identifier that you provide to ensure the
idempotency—that is, the uniqueness—of the request.}
}
\description{
Create a listener to process inbound connections from clients to a
custom routing accelerator. Connections arrive to assigned static IP
addresses on the port range that you specify.
}
\section{Request syntax}{
\preformatted{svc$create_custom_routing_listener(
  AcceleratorArn = "string",
  PortRanges = list(
    list(
      FromPort = 123,
      ToPort = 123
    )
  ),
  IdempotencyToken = "string"
)
}
}

\keyword{internal}
