% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_delete_vpc_association_authorization}
\alias{route53_delete_vpc_association_authorization}
\title{Removes authorization to submit an AssociateVPCWithHostedZone request to
associate a specified VPC with a hosted zone that was created by a
different account}
\usage{
route53_delete_vpc_association_authorization(HostedZoneId, VPC)
}
\arguments{
\item{HostedZoneId}{[required] When removing authorization to associate a VPC that was created by one
AWS account with a hosted zone that was created with a different AWS
account, the ID of the hosted zone.}

\item{VPC}{[required] When removing authorization to associate a VPC that was created by one
AWS account with a hosted zone that was created with a different AWS
account, a complex type that includes the ID and region of the VPC.}
}
\description{
Removes authorization to submit an \code{AssociateVPCWithHostedZone} request
to associate a specified VPC with a hosted zone that was created by a
different account. You must use the account that created the hosted zone
to submit a \code{DeleteVPCAssociationAuthorization} request.
}
\details{
Sending this request only prevents the AWS account that created the VPC
from associating the VPC with the Amazon Route 53 hosted zone in the
future. If the VPC is already associated with the hosted zone,
\code{DeleteVPCAssociationAuthorization} won't disassociate the VPC from the
hosted zone. If you want to delete an existing association, use
\code{DisassociateVPCFromHostedZone}.
}
\section{Request syntax}{
\preformatted{svc$delete_vpc_association_authorization(
  HostedZoneId = "string",
  VPC = list(
    VPCRegion = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-south-1"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"ca-central-1"|"cn-north-1",
    VPCId = "string"
  )
)
}
}

\keyword{internal}
